/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.metadata;

import com.clickhouse.client.api.metadata.NoSuchColumnException;
import com.clickhouse.data.ClickHouseColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableSchema {
    private String tableName = "";
    private String query = "";
    private String databaseName = "";
    private List<ClickHouseColumn> columns;
    private List<ClickHouseColumn> columnsView;
    private Map<String, Map<String, Object>> metadata = new HashMap<String, Map<String, Object>>();
    private Map<String, Integer> colIndex;
    private boolean hasDefaults = false;

    public TableSchema() {
        this.columns = new ArrayList<ClickHouseColumn>();
        this.columnsView = Collections.unmodifiableList(this.columns);
        this.colIndex = new HashMap<String, Integer>();
    }

    public List<ClickHouseColumn> getColumns() {
        return this.columnsView;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean hasDefaults() {
        return this.hasDefaults;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void addColumn(String name, String type) {
        this.addColumn(name, type, "");
    }

    public void addColumn(String name, String type, String defaultType) {
        ClickHouseColumn column = ClickHouseColumn.of(name, type);
        if (defaultType.toUpperCase().contains("DEFAULT")) {
            this.hasDefaults = true;
            column.setHasDefault(true);
        }
        this.columns.add(column);
        Map columnMetadata = this.metadata.computeIfAbsent(name, k -> new HashMap());
        columnMetadata.put("type", type);
        this.colIndex.put(name, this.columns.size() - 1);
    }

    public ClickHouseColumn getColumnByName(String name) {
        return this.columns.get(this.nameToIndex(name));
    }

    public String indexToName(int index) {
        try {
            return this.columns.get(index).getColumnName();
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchColumnException("Result has no column with index = " + index);
        }
    }

    public String columnIndexToName(int index) {
        return this.indexToName(index - 1);
    }

    public int nameToColumnIndex(String name) {
        return this.nameToIndex(name) + 1;
    }

    public int nameToIndex(String name) {
        Integer index = this.colIndex.get(name);
        if (index == null) {
            throw new NoSuchColumnException("Result has no column with name '" + name + "'");
        }
        return this.colIndex.get(name);
    }

    public String toString() {
        return "TableSchema{tableName='" + this.tableName + '\'' + ", databaseName='" + this.databaseName + '\'' + ", columns=" + this.columns + ", metadata=" + this.metadata + ", colIndex=" + this.colIndex + ", hasDefaults=" + this.hasDefaults + '}';
    }
}

