/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import org.apache.flink.runtime.rest.messages.ConversionException;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;

public class SubtaskIndexQueryParameter
extends MessageQueryParameter<Integer> {
    public static final String KEY = "subtaskindex";

    public SubtaskIndexQueryParameter() {
        super(KEY, MessageParameter.MessageParameterRequisiteness.OPTIONAL);
    }

    @Override
    public Integer convertStringToValue(String value) throws ConversionException {
        int subtaskIndex = Integer.parseInt(value);
        if (subtaskIndex >= 0) {
            return subtaskIndex;
        }
        throw new ConversionException("subtaskindex must be positive, was: " + subtaskIndex);
    }

    @Override
    public String convertValueToString(Integer value) {
        return value.toString();
    }

    @Override
    public String getDescription() {
        return "Positive integer value that identifies a subtask.";
    }
}

