/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.jobmaster.JobManagerRunnerResult;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.concurrent.FutureUtils;

public interface JobMasterServiceProcess
extends AutoCloseableAsync {
    public static JobMasterServiceProcess waitingForLeadership() {
        return WaitingForLeadership.INSTANCE;
    }

    public UUID getLeaderSessionId();

    public boolean isInitializedAndRunning();

    public CompletableFuture<JobMasterGateway> getJobMasterGatewayFuture();

    public CompletableFuture<JobManagerRunnerResult> getResultFuture();

    public CompletableFuture<String> getLeaderAddressFuture();

    public static enum WaitingForLeadership implements JobMasterServiceProcess
    {
        INSTANCE;


        public CompletableFuture<Void> closeAsync() {
            return FutureUtils.completedVoidFuture();
        }

        @Override
        public UUID getLeaderSessionId() {
            throw new UnsupportedOperationException("Still waiting for the leadership.");
        }

        @Override
        public boolean isInitializedAndRunning() {
            return false;
        }

        @Override
        public CompletableFuture<JobMasterGateway> getJobMasterGatewayFuture() {
            return this.failedOperationFuture();
        }

        @Override
        public CompletableFuture<JobManagerRunnerResult> getResultFuture() {
            return this.failedOperationFuture();
        }

        @Override
        public CompletableFuture<String> getLeaderAddressFuture() {
            return this.failedOperationFuture();
        }

        @Nonnull
        private <T> CompletableFuture<T> failedOperationFuture() {
            return FutureUtils.completedExceptionally((Throwable)new FlinkException("Still waiting for the leadership."));
        }
    }
}

