/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;

public class StateObjectCollection<T extends StateObject>
implements Collection<T>,
StateObject {
    private static final long serialVersionUID = 1L;
    private static final StateObjectCollection<?> EMPTY = new StateObjectCollection(Collections.emptyList());
    private final Collection<T> stateObjects;

    public StateObjectCollection() {
        this.stateObjects = new ArrayList<T>();
    }

    public StateObjectCollection(Collection<T> stateObjects) {
        this.stateObjects = stateObjects != null ? stateObjects : Collections.emptyList();
    }

    @Override
    public int size() {
        return this.stateObjects.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stateObjects.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.stateObjects.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stateObjects.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.stateObjects.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.stateObjects.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.stateObjects.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.stateObjects.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.stateObjects.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.stateObjects.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.stateObjects.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.stateObjects.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.stateObjects.retainAll(c);
    }

    @Override
    public void clear() {
        this.stateObjects.clear();
    }

    @Override
    public void discardState() throws Exception {
        StateUtil.bestEffortDiscardAllStateObjects(this.stateObjects);
    }

    @Override
    public long getStateSize() {
        return this.streamAllStateObjects().mapToLong(StateObject::getStateSize).sum();
    }

    @Override
    public void collectSizeStats(StateObject.StateObjectSizeStatsCollector collector) {
        this.streamAllStateObjects().forEach(object -> object.collectSizeStats(collector));
    }

    public long getCheckpointedSize() {
        return this.streamAllStateObjects().mapToLong(StateObjectCollection::getCheckpointedSizeNullSafe).sum();
    }

    private Stream<T> streamAllStateObjects() {
        return this.stateObjects.stream().filter(Objects::nonNull);
    }

    public boolean hasState() {
        for (StateObject state : this.stateObjects) {
            if (state == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateObjectCollection that = (StateObjectCollection)o;
        return CollectionUtils.isEqualCollection(this.stateObjects, that.stateObjects);
    }

    @Override
    public int hashCode() {
        return this.stateObjects.hashCode();
    }

    public String toString() {
        return "StateObjectCollection{" + this.stateObjects + '}';
    }

    public List<T> asList() {
        return this.stateObjects instanceof List ? (ArrayList<T>)this.stateObjects : (this.stateObjects != null ? new ArrayList<T>(this.stateObjects) : Collections.emptyList());
    }

    public static <T extends StateObject> StateObjectCollection<T> empty() {
        return EMPTY;
    }

    public static <T extends StateObject> StateObjectCollection<T> emptyIfNull(@Nullable StateObjectCollection<T> collection) {
        return collection == null ? StateObjectCollection.empty() : collection;
    }

    public static <T extends StateObject> StateObjectCollection<T> singleton(T stateObject) {
        return new StateObjectCollection<T>(Collections.singleton(stateObject));
    }

    public static <T extends StateObject> StateObjectCollection<T> singletonOrEmpty(@Nullable T stateObject) {
        return stateObject == null ? StateObjectCollection.empty() : StateObjectCollection.singleton(stateObject);
    }

    private static long getSizeNullSafe(StateObject stateObject) {
        return stateObject != null ? stateObject.getStateSize() : 0L;
    }

    private static long getCheckpointedSizeNullSafe(StateObject stateObject) {
        return stateObject instanceof CompositeStateHandle ? ((CompositeStateHandle)stateObject).getCheckpointedSize() : StateObjectCollection.getSizeNullSafe(stateObject);
    }
}

