/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row.value;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaPlugin;

@ValueMetaPlugin(id="11", name="JSON", description="JSON object", image="images/json.svg")
public class ValueMetaJson
extends ValueMetaBase {
    private boolean prettyPrinting = true;

    @Override
    public int compare(Object data1, Object data2) throws HopValueException {
        JsonNode json1 = (JsonNode)data1;
        JsonNode json2 = (JsonNode)data2;
        String string1 = this.convertJsonToString(json1);
        String string2 = this.convertJsonToString(json2);
        return string1.compareTo(string2);
    }

    public ValueMetaJson() {
        this((String)null);
    }

    public ValueMetaJson(String name) {
        super(name, 11);
    }

    @Override
    public String getString(Object object) throws HopValueException {
        return this.convertJsonToString(this.getJson(object));
    }

    @Override
    public String convertJsonToString(JsonNode jsonNode) throws HopValueException {
        try {
            ObjectMapper objectMapper = HopJson.newMapper();
            if (this.prettyPrinting) {
                return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
            }
            return objectMapper.writeValueAsString((Object)jsonNode);
        }
        catch (Exception e) {
            throw new HopValueException("Error converting JSON value to String", e);
        }
    }

    @Override
    public Object cloneValueData(Object object) throws HopValueException {
        JsonNode jsonNode = this.getJson(object);
        if (jsonNode == null) {
            return null;
        }
        try {
            String jsonString = this.convertJsonToString(jsonNode);
            return this.convertStringToJson(jsonString);
        }
        catch (Exception e) {
            throw new HopValueException("Unable to clone JSON value", e);
        }
    }

    @Override
    public Object getNativeDataType(Object object) throws HopValueException {
        return this.getJson(object);
    }

    @Override
    public Class<?> getNativeDataTypeClass() throws HopValueException {
        return JsonNode.class;
    }

    public boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    public void setPrettyPrinting(boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
    }
}

