/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.dataformat.avro.AvroFactory;
import com.fasterxml.jackson.dataformat.avro.AvroGenerator;
import com.fasterxml.jackson.dataformat.avro.AvroModule;
import com.fasterxml.jackson.dataformat.avro.AvroParser;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import com.fasterxml.jackson.dataformat.avro.PackageVersion;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;

public class AvroMapper
extends ObjectMapper {
    private static final long serialVersionUID = 2L;

    public AvroMapper() {
        this(new AvroFactory());
    }

    public AvroMapper(AvroFactory f) {
        super((JsonFactory)f);
        this.registerModule(new AvroModule());
    }

    public AvroMapper(Module ... modules) {
        super((JsonFactory)new AvroFactory());
        this.registerModules(modules);
    }

    public AvroMapper(AvroFactory f, Module ... modules) {
        super((JsonFactory)f);
        this.registerModules(modules);
    }

    protected AvroMapper(ObjectMapper src) {
        super(src);
    }

    public static Builder xmlBuilder() {
        return new Builder(new AvroMapper());
    }

    public static Builder builder() {
        return new Builder(new AvroMapper());
    }

    public static Builder builder(AvroFactory streamFactory) {
        return new Builder(new AvroMapper(streamFactory));
    }

    public AvroMapper copy() {
        this._checkInvalidCopy(AvroMapper.class);
        return new AvroMapper(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public AvroFactory getFactory() {
        return (AvroFactory)this._jsonFactory;
    }

    public AvroSchema schemaFor(Class<?> type) throws JsonMappingException {
        AvroSchemaGenerator gen = new AvroSchemaGenerator();
        try {
            this.acceptJsonFormatVisitor(type, gen);
            return gen.getGeneratedSchema();
        }
        catch (RuntimeException e0) {
            throw this._invalidSchemaDefinition(this.constructType(type), e0);
        }
    }

    public AvroSchema schemaFor(JavaType type) throws JsonMappingException {
        AvroSchemaGenerator gen = new AvroSchemaGenerator();
        try {
            this.acceptJsonFormatVisitor(type, gen);
            return gen.getGeneratedSchema();
        }
        catch (RuntimeException e0) {
            throw this._invalidSchemaDefinition(type, e0);
        }
    }

    protected JsonMappingException _invalidSchemaDefinition(JavaType type, Exception e0) {
        String msg = String.format("Failed to generate `AvroSchema` for %s, problem: (%s) %s", ClassUtil.getTypeDescription((JavaType)type), e0.getClass().getName(), e0.getMessage());
        return InvalidDefinitionException.from((JsonGenerator)null, (String)msg, (JavaType)type).withCause((Throwable)e0);
    }

    public AvroSchema schemaFrom(InputStream in) throws IOException {
        try {
            AvroSchema avroSchema = new AvroSchema(new Schema.Parser().setValidate(true).parse(in));
            return avroSchema;
        }
        finally {
            in.close();
        }
    }

    public AvroSchema schemaFrom(String schemaAsString) throws IOException {
        return new AvroSchema(new Schema.Parser().setValidate(true).parse(schemaAsString));
    }

    public AvroSchema schemaFrom(File schemaFile) throws IOException {
        return new AvroSchema(new Schema.Parser().setValidate(true).parse(schemaFile));
    }

    public static class Builder
    extends MapperBuilder<AvroMapper, Builder> {
        protected final AvroFactory _streamFactory;

        public Builder(AvroMapper m) {
            super((ObjectMapper)m);
            this._streamFactory = m.getFactory();
        }

        public Builder enable(AvroParser.Feature ... features) {
            for (AvroParser.Feature f : features) {
                this._streamFactory.enable(f);
            }
            return this;
        }

        public Builder disable(AvroParser.Feature ... features) {
            for (AvroParser.Feature f : features) {
                this._streamFactory.disable(f);
            }
            return this;
        }

        public Builder configure(AvroParser.Feature f, boolean state) {
            if (state) {
                this._streamFactory.enable(f);
            } else {
                this._streamFactory.disable(f);
            }
            return this;
        }

        public Builder enable(AvroGenerator.Feature ... features) {
            for (AvroGenerator.Feature f : features) {
                this._streamFactory.enable(f);
            }
            return this;
        }

        public Builder disable(AvroGenerator.Feature ... features) {
            for (AvroGenerator.Feature f : features) {
                this._streamFactory.disable(f);
            }
            return this;
        }

        public Builder configure(AvroGenerator.Feature f, boolean state) {
            if (state) {
                this._streamFactory.enable(f);
            } else {
                this._streamFactory.disable(f);
            }
            return this;
        }
    }
}

