/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.workflow.meta;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.DummyMeta;
import org.apache.hop.reflection.workflow.meta.WorkflowLog;
import org.apache.hop.reflection.workflow.transform.WorkflowLoggingMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WorkflowLogEditor
extends MetadataEditor<WorkflowLog> {
    private static final Class<?> PKG = WorkflowLogEditor.class;
    private Text wName;
    private Button wEnabled;
    private Button wLoggingParentsOnly;
    private TextVar wFilename;
    private Button wAtStart;
    private Button wAtEnd;
    private Button wPeriodic;
    private Label wlInterval;
    private TextVar wInterval;
    private TableView wWorkflows;

    public WorkflowLogEditor(HopGui hopGui, MetadataManager<WorkflowLog> manager, WorkflowLog metadata) {
        super(hopGui, manager, (IHopMetadata)metadata);
    }

    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wIcon = new Label(parent, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlIcon = new FormData();
        fdlIcon.top = new FormAttachment(0, 0);
        fdlIcon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlIcon);
        PropsUi.setLook((Widget)wIcon);
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"WorkflowLoggingEditor.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment((Control)wIcon, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label spacer = new Label(parent, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        Label lastControl = spacer;
        Label wlEnabled = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlEnabled);
        wlEnabled.setText(BaseMessages.getString(PKG, (String)"WorkflowLoggingEditor.Enabled.Label", (String[])new String[0]));
        FormData fdlEnabled = new FormData();
        fdlEnabled.left = new FormAttachment(0, 0);
        fdlEnabled.right = new FormAttachment(middle, 0);
        fdlEnabled.top = new FormAttachment((Control)lastControl, margin);
        wlEnabled.setLayoutData((Object)fdlEnabled);
        this.wEnabled = new Button(parent, 16416);
        PropsUi.setLook((Widget)this.wEnabled);
        FormData fdEnabled = new FormData();
        fdEnabled.left = new FormAttachment(middle, margin);
        fdEnabled.right = new FormAttachment(100, 0);
        fdEnabled.top = new FormAttachment((Control)wlEnabled, 0, 0x1000000);
        this.wEnabled.setLayoutData((Object)fdEnabled);
        lastControl = wlEnabled;
        Label wlLoggingParentsOnly = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlLoggingParentsOnly);
        wlLoggingParentsOnly.setText(BaseMessages.getString(PKG, (String)"WorkflowLoggingEditor.LoggingParentsOnly.Label", (String[])new String[0]));
        FormData fdlLoggingParentsOnly = new FormData();
        fdlLoggingParentsOnly.left = new FormAttachment(0, 0);
        fdlLoggingParentsOnly.right = new FormAttachment(middle, 0);
        fdlLoggingParentsOnly.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlLoggingParentsOnly.setLayoutData((Object)fdlLoggingParentsOnly);
        this.wLoggingParentsOnly = new Button(parent, 16416);
        PropsUi.setLook((Widget)this.wLoggingParentsOnly);
        FormData fdLoggingParentsOnly = new FormData();
        fdLoggingParentsOnly.left = new FormAttachment(middle, margin);
        fdLoggingParentsOnly.right = new FormAttachment(100, 0);
        fdLoggingParentsOnly.top = new FormAttachment((Control)wlLoggingParentsOnly, 0, 0x1000000);
        this.wLoggingParentsOnly.setLayoutData((Object)fdLoggingParentsOnly);
        lastControl = wlLoggingParentsOnly;
        Label wlFilename = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlFilename);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"WorkflowLoggingEditor.Filename.Label", (String[])new String[0]));
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(middle, 0);
        fdlFilename.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbbFilename = new Button(parent, 8);
        PropsUi.setLook((Widget)wbbFilename);
        wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbbFilename = new FormData();
        fdbbFilename.right = new FormAttachment(100, 0);
        fdbbFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wbbFilename.setLayoutData((Object)fdbbFilename);
        wbbFilename.addListener(13, e -> this.selectPipelineFilename(parent));
        Button wbnFilename = new Button(parent, 8);
        PropsUi.setLook((Widget)wbnFilename);
        wbnFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.New", (String[])new String[0]));
        FormData fdbnFilename = new FormData();
        fdbnFilename.right = new FormAttachment((Control)wbbFilename, -margin);
        fdbnFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wbnFilename.setLayoutData((Object)fdbnFilename);
        wbnFilename.addListener(13, e -> this.createPipelineFile(parent));
        Button wboFilename = new Button(parent, 8);
        PropsUi.setLook((Widget)wboFilename);
        wboFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Open", (String[])new String[0]));
        FormData fdboFilename = new FormData();
        fdboFilename.right = new FormAttachment((Control)wbnFilename, -margin);
        fdboFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wboFilename.setLayoutData((Object)fdboFilename);
        wboFilename.addListener(13, e -> this.openPipelineFile(parent));
        this.wFilename = new TextVar(this.manager.getVariables(), parent, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, margin);
        fdFilename.right = new FormAttachment((Control)wboFilename, -margin);
        fdFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        this.wFilename.setLayoutData((Object)fdFilename);
        lastControl = wlFilename;
        Label wlAtStart = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlAtStart);
        wlAtStart.setText(BaseMessages.getString(PKG, (String)"WorkflowLoggingEditor.AtStart.Label", (String[])new String[0]));
        FormData fdlAtStart = new FormData();
        fdlAtStart.left = new FormAttachment(0, 0);
        fdlAtStart.right = new FormAttachment(middle, 0);
        fdlAtStart.top = new FormAttachment((Control)lastControl, margin);
        wlAtStart.setLayoutData((Object)fdlAtStart);
        this.wAtStart = new Button(parent, 16416);
        PropsUi.setLook((Widget)this.wAtStart);
        FormData fdAtStart = new FormData();
        fdAtStart.left = new FormAttachment(middle, margin);
        fdAtStart.right = new FormAttachment(100, 0);
        fdAtStart.top = new FormAttachment((Control)wlAtStart, 0, 0x1000000);
        this.wAtStart.setLayoutData((Object)fdAtStart);
        lastControl = wlAtStart;
        Label wlAtEnd = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlAtEnd);
        wlAtEnd.setText(BaseMessages.getString(PKG, (String)"WorkflowLoggingEditor.AtEnd.Label", (String[])new String[0]));
        FormData fdlAtEnd = new FormData();
        fdlAtEnd.left = new FormAttachment(0, 0);
        fdlAtEnd.right = new FormAttachment(middle, 0);
        fdlAtEnd.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlAtEnd.setLayoutData((Object)fdlAtEnd);
        this.wAtEnd = new Button(parent, 16416);
        PropsUi.setLook((Widget)this.wAtEnd);
        FormData fdAtEnd = new FormData();
        fdAtEnd.left = new FormAttachment(middle, margin);
        fdAtEnd.right = new FormAttachment(100, 0);
        fdAtEnd.top = new FormAttachment((Control)wlAtEnd, 0, 0x1000000);
        this.wAtEnd.setLayoutData((Object)fdAtEnd);
        lastControl = wlAtEnd;
        Label wlPeriodic = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlPeriodic);
        wlPeriodic.setText(BaseMessages.getString(PKG, (String)"WorkflowLoggingEditor.Periodic.Label", (String[])new String[0]));
        FormData fdlPeriodic = new FormData();
        fdlPeriodic.left = new FormAttachment(0, 0);
        fdlPeriodic.right = new FormAttachment(middle, 0);
        fdlPeriodic.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlPeriodic.setLayoutData((Object)fdlPeriodic);
        this.wPeriodic = new Button(parent, 16416);
        PropsUi.setLook((Widget)this.wPeriodic);
        FormData fdPeriodic = new FormData();
        fdPeriodic.left = new FormAttachment(middle, margin);
        fdPeriodic.right = new FormAttachment(100, 0);
        fdPeriodic.top = new FormAttachment((Control)wlPeriodic, 0, 0x1000000);
        this.wPeriodic.setLayoutData((Object)fdPeriodic);
        lastControl = wlPeriodic;
        this.wlInterval = new Label(parent, 131072);
        PropsUi.setLook((Widget)this.wlInterval);
        this.wlInterval.setText(BaseMessages.getString(PKG, (String)"WorkflowLoggingEditor.Interval.Label", (String[])new String[0]));
        FormData fdlInterval = new FormData();
        fdlInterval.left = new FormAttachment(0, 0);
        fdlInterval.right = new FormAttachment(middle, 0);
        fdlInterval.top = new FormAttachment((Control)lastControl, 2 * margin);
        this.wlInterval.setLayoutData((Object)fdlInterval);
        this.wInterval = new TextVar(this.manager.getVariables(), parent, 18436);
        PropsUi.setLook((Widget)this.wInterval);
        FormData fdInterval = new FormData();
        fdInterval.left = new FormAttachment(middle, margin);
        fdInterval.right = new FormAttachment(100, 0);
        fdInterval.top = new FormAttachment((Control)this.wlInterval, 0, 0x1000000);
        this.wInterval.setLayoutData((Object)fdInterval);
        this.wInterval.addListener(13, this::enableFields);
        lastControl = this.wlInterval;
        Label wlSources = new Label(parent, 16384);
        PropsUi.setLook((Widget)wlSources);
        wlSources.setText(BaseMessages.getString(PKG, (String)"WorkflowLoggingEditor.Sources.Label", (String[])new String[0]));
        FormData fdlSources = new FormData();
        fdlSources.left = new FormAttachment(0, 0);
        fdlSources.right = new FormAttachment(100, 0);
        fdlSources.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlSources.setLayoutData((Object)fdlSources);
        lastControl = wlSources;
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowLoggingEditor.SourcesTable.Column.Pipeline", (String[])new String[0]), 1, false, false)};
        this.wWorkflows = new TableView(this.manager.getVariables(), parent, 2048, columns, 0, e -> this.setChanged(), props);
        FormData fdSources = new FormData();
        fdSources.left = new FormAttachment(0, 0);
        fdSources.top = new FormAttachment((Control)lastControl, margin);
        fdSources.right = new FormAttachment(100, 0);
        fdSources.bottom = new FormAttachment(100, 0);
        this.wWorkflows.setLayoutData((Object)fdSources);
        this.setWidgetsContent();
        Listener modifyListener = e -> this.setChanged();
        this.wName.addListener(24, modifyListener);
        this.wEnabled.addListener(13, modifyListener);
        this.wLoggingParentsOnly.addListener(13, modifyListener);
        this.wFilename.addListener(24, modifyListener);
        this.wAtStart.addListener(13, modifyListener);
        this.wAtEnd.addListener(13, modifyListener);
        this.wPeriodic.addListener(13, modifyListener);
        this.wInterval.addListener(24, modifyListener);
    }

    private void createPipelineFile(Composite parent) {
        try {
            PipelineMeta pipelineMeta = new PipelineMeta();
            WorkflowLoggingMeta workflowLoggingMeta = new WorkflowLoggingMeta();
            workflowLoggingMeta.setLoggingActionResults(true);
            TransformMeta workflowLogging = new TransformMeta("Workflow Logging", (ITransformMeta)workflowLoggingMeta);
            workflowLogging.setLocation(200, 150);
            pipelineMeta.addTransform(workflowLogging);
            DummyMeta dummyMeta = new DummyMeta();
            TransformMeta dummy = new TransformMeta("Save logging here", (ITransformMeta)dummyMeta);
            dummy.setLocation(500, 150);
            pipelineMeta.addTransform(dummy);
            pipelineMeta.addPipelineHop(new PipelineHopMeta(workflowLogging, dummy));
            HopPipelineFileType type = new HopPipelineFileType();
            String filename = BaseDialog.presentFileDialog((boolean)true, (Shell)parent.getShell(), (TextVar)this.wFilename, (IVariables)this.manager.getVariables(), (String[])type.getFilterExtensions(), (String[])type.getFilterNames(), (boolean)true);
            if (filename != null) {
                String realFilename = this.manager.getVariables().resolve(filename);
                pipelineMeta.setFilename(realFilename);
                pipelineMeta.clearChanged();
                HopDataOrchestrationPerspective perspective = HopGui.getDataOrchestrationPerspective();
                perspective.activate();
                HopGui.getDataOrchestrationPerspective().addPipeline(this.hopGui, pipelineMeta, type);
                this.hopGui.fileDelegate.fileSave();
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent.getShell(), "Error", "Error creating pipeline", e);
        }
    }

    private void openPipelineFile(Composite parent) {
        try {
            String filename = this.manager.getVariables().resolve(this.wFilename.getText());
            if (StringUtils.isNotEmpty((String)filename)) {
                this.hopGui.fileDelegate.fileOpen(filename);
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent.getShell(), "Error", "Error creating pipeline", e);
        }
    }

    private void selectPipelineFilename(Composite parent) {
        HopPipelineFileType type = new HopPipelineFileType();
        BaseDialog.presentFileDialog((Shell)parent.getShell(), (TextVar)this.wFilename, (IVariables)this.manager.getVariables(), (String[])type.getFilterExtensions(), (String[])type.getFilterNames(), (boolean)true);
    }

    private void enableFields(Event event) {
        boolean intervalEnabled = this.wPeriodic.getSelection();
        this.wlInterval.setEnabled(intervalEnabled);
        this.wInterval.setEnabled(intervalEnabled);
    }

    public void setWidgetsContent() {
        WorkflowLog wl = (WorkflowLog)this.getMetadata();
        this.wName.setText(Const.NVL((String)wl.getName(), (String)""));
        this.wEnabled.setSelection(wl.isEnabled());
        this.wLoggingParentsOnly.setSelection(wl.isLoggingParentsOnly());
        this.wFilename.setText(Const.NVL((String)wl.getPipelineFilename(), (String)""));
        this.wAtStart.setSelection(wl.isExecutingAtStart());
        this.wAtEnd.setSelection(wl.isExecutingAtEnd());
        this.wPeriodic.setSelection(wl.isExecutingPeriodically());
        this.wInterval.setText(Const.NVL((String)wl.getIntervalInSeconds(), (String)""));
        this.wWorkflows.removeAll();
        List<String> workflowsToLog = wl.getWorkflowToLog();
        for (String workflowToLog : workflowsToLog) {
            TableItem item = new TableItem(this.wWorkflows.table, 0);
            item.setText(1, Const.NVL((String)workflowToLog, (String)""));
        }
        this.wWorkflows.setRowNums();
        this.wWorkflows.optimizeTableView();
    }

    public void getWidgetsContent(WorkflowLog pl) {
        pl.setName(this.wName.getText());
        pl.setEnabled(this.wEnabled.getSelection());
        pl.setLoggingParentsOnly(this.wLoggingParentsOnly.getSelection());
        pl.setPipelineFilename(this.wFilename.getText());
        pl.setExecutingAtStart(this.wAtStart.getSelection());
        pl.setExecutingAtEnd(this.wAtEnd.getSelection());
        pl.setExecutingPeriodically(this.wPeriodic.getSelection());
        pl.setIntervalInSeconds(this.wInterval.getText());
        ArrayList<String> locations = new ArrayList<String>();
        List items = this.wWorkflows.getNonEmptyItems();
        for (TableItem item : items) {
            locations.add(item.getText(1));
        }
        pl.setWorkflowToLog(locations);
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }
}

