/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazonaws.SdkClientException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class PingCredentialsProvider
extends SamlCredentialsProvider {
    private static final Pattern SAML_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");
    private static final String KEY_PARTNER_SPID = "partner_spid";
    protected String m_partnerSpId;

    @Override
    public void addParameter(String key, String value) {
        super.addParameter(key, value);
        if (KEY_PARTNER_SPID.equalsIgnoreCase(key)) {
            this.m_partnerSpId = value;
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return this.m_partnerSpId != null ? this.m_partnerSpId : "";
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        String string;
        this.checkRequiredParameters();
        this.m_partnerSpId = StringUtils.isNullOrEmpty((String)this.m_partnerSpId) ? "urn%3Aamazon%3Awebservices" : URLEncoder.encode(this.m_partnerSpId, "UTF-8");
        String uri = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/idp/startSSO.ping?PartnerSpId=" + this.m_partnerSpId;
        CloseableHttpClient client = null;
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(5);
        try {
            String name;
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("uri: {0}", uri);
            }
            this.validateURL(uri);
            client = this.getHttpClient();
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
            if (resp.getStatusLine().getStatusCode() != 200) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.DEBUG, "getSamlAssertion https response:" + EntityUtils.toString((HttpEntity)resp.getEntity()), new Object[0]);
                }
                throw new IOException("Failed send request: " + resp.getStatusLine().getReasonPhrase());
            }
            HttpEntity entity = resp.getEntity();
            String body = EntityUtils.toString((HttpEntity)entity);
            BasicNameValuePair username = null;
            BasicNameValuePair pass = null;
            String password_tag = null;
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("body: {0}", body);
            }
            for (String inputTag : this.getInputTagsfromHTML(body)) {
                name = this.getValueByKey(inputTag, "name");
                String id = this.getValueByKey(inputTag, "id");
                String value = this.getValueByKey(inputTag, "value");
                if (RedshiftLogger.isEnable()) {
                    this.m_log.logDebug("name: {0} , id: {1}", name, id);
                }
                if (username == null && ("username".equals(id) || "pf.username".equals(id) || "username".equals(name) || "pf.username".equals(name)) && this.isText(inputTag)) {
                    username = new BasicNameValuePair(name, this.m_userName);
                    continue;
                }
                if (("pf.pass".equals(name) || name.contains("pass")) && this.isPassword(inputTag)) {
                    if (pass != null) {
                        if (RedshiftLogger.isEnable()) {
                            this.m_log.log(LogLevel.DEBUG, String.format("pass field: %s has conflict with field: %s", password_tag, inputTag), new Object[0]);
                            this.m_log.log(LogLevel.DEBUG, body, new Object[0]);
                        }
                        throw new IOException("Duplicate password fields on login page.");
                    }
                    password_tag = inputTag;
                    pass = new BasicNameValuePair(name, this.m_password);
                    continue;
                }
                if (StringUtils.isNullOrEmpty((String)name)) continue;
                parameters.add(new BasicNameValuePair(name, value));
            }
            if (username == null) {
                for (String inputTag : this.getInputTagsfromHTML(body)) {
                    name = this.getValueByKey(inputTag, "name");
                    if (RedshiftLogger.isEnable()) {
                        this.m_log.log(LogLevel.DEBUG, String.format("inputTag: %s has name with field: %s", inputTag, name), new Object[0]);
                    }
                    if (!"email".equals(name) && !name.contains("user") && !name.contains("email") || !this.isText(inputTag)) continue;
                    username = new BasicNameValuePair(name, this.m_userName);
                }
            }
            if (username == null || pass == null) {
                boolean noPass;
                boolean noUserName = username == null;
                boolean bl = noPass = pass == null;
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.DEBUG, body, new Object[0]);
                }
                throw new IOException("Failed to parse login form. noUserName = " + noUserName + " noPass=" + noPass);
            }
            parameters.add(username);
            parameters.add(pass);
            String action = this.getFormAction(body);
            if (!StringUtils.isNullOrEmpty((String)action) && action.startsWith("/")) {
                uri = "https://" + this.m_idpHost + ':' + this.m_idpPort + action;
            }
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("action uri: {0}", uri);
            }
            this.validateURL(uri);
            HttpPost post = new HttpPost(uri);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            resp = client.execute((HttpUriRequest)post);
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + resp.getStatusLine().getReasonPhrase());
            }
            String content = EntityUtils.toString((HttpEntity)resp.getEntity());
            Matcher matcher = SAML_PATTERN.matcher(content);
            if (!matcher.find()) {
                throw new IOException("Failed to retrieve SAMLAssertion.");
            }
            string = matcher.group(1);
        }
        catch (GeneralSecurityException e) {
            try {
                throw new SdkClientException("Failed create SSLContext.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(client, null);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)client, null);
        return string;
    }
}

