/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class UnversionedTypeSerializerSnapshot<@UnknownKeyFor T>
implements TypeSerializerSnapshot<T> {
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized CoderTypeSerializer<T> serializer;

    public UnversionedTypeSerializerSnapshot() {
        this(null);
    }

    public UnversionedTypeSerializerSnapshot(@UnknownKeyFor @NonNull @Initialized CoderTypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public @UnknownKeyFor @NonNull @Initialized int getCurrentVersion() {
        return 1;
    }

    public void writeSnapshot(@UnknownKeyFor @NonNull @Initialized DataOutputView dataOutputView) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] bytes = SerializableUtils.serializeToByteArray(this.serializer);
        dataOutputView.writeInt(bytes.length);
        dataOutputView.write(bytes);
    }

    public void readSnapshot(@UnknownKeyFor @NonNull @Initialized int version, @UnknownKeyFor @NonNull @Initialized DataInputView dataInputView, @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (TemporaryClassLoaderContext context = TemporaryClassLoaderContext.of((ClassLoader)classLoader);){
            int length = dataInputView.readInt();
            byte[] bytes = new byte[length];
            dataInputView.readFully(bytes);
            this.serializer = (CoderTypeSerializer)((Object)SerializableUtils.deserializeFromByteArray((byte[])bytes, (String)CoderTypeSerializer.class.getName()));
        }
    }

    public @UnknownKeyFor @NonNull @Initialized TypeSerializer<T> restoreSerializer() {
        return this.serializer;
    }

    public @UnknownKeyFor @NonNull @Initialized TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(@UnknownKeyFor @NonNull @Initialized TypeSerializer<T> newSerializer) {
        return TypeSerializerSchemaCompatibility.compatibleAsIs();
    }
}

