/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import net.ucanaccess.commands.DDLCommandEnlist;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.exception.TableNotFoundException;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.jdbc.Execute;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessResultSet;
import net.ucanaccess.jdbc.UcanaccessStatement;
import net.ucanaccess.util.HibernateSupport;

public abstract class AbstractExecute {
    private UcanaccessResultSet resultSet;
    private UcanaccessStatement statement;
    private CommandType commandType;
    private String sql;
    private int autoGeneratedKeys;
    private String[] columnNames;
    private int[] indexes;

    protected AbstractExecute(UcanaccessResultSet _resultSet) {
        this(_resultSet.getWrappedStatement(), CommandType.UPDATABLE_RESULTSET, null, 0, null, null);
        this.resultSet = _resultSet;
    }

    protected AbstractExecute(UcanaccessStatement _statement, CommandType _commandType, String _sql, int _autoGeneratedKeys, String[] _columnNames, int[] _indexes) {
        this.statement = _statement;
        this.commandType = _commandType;
        this.sql = _sql;
        this.autoGeneratedKeys = _autoGeneratedKeys;
        this.columnNames = _columnNames;
        this.indexes = _indexes;
    }

    protected AbstractExecute(UcanaccessStatement _statement) {
        this.statement = _statement;
    }

    private Object enableDisable(SQLConverter.DDLType _ddlType) throws SQLException, IOException {
        UcanaccessConnection conn;
        Metadata mtd;
        String rtn;
        String tableName = Objects.requireNonNull(_ddlType.getDBObjectName());
        if (tableName.startsWith("[") && tableName.endsWith("]")) {
            tableName = tableName.substring(1, tableName.length() - 1);
        }
        if ((rtn = (mtd = new Metadata((conn = this.statement.getConnection()).getHSQLDBConnection())).getTableName(tableName)) == null) {
            throw new TableNotFoundException(tableName);
        }
        boolean enableAutoIncr = _ddlType.equals((Object)SQLConverter.DDLType.ENABLE_AUTOINCREMENT);
        conn.getDbIO().getTable(rtn).setAllowAutoNumberInsert(Boolean.valueOf(!enableAutoIncr));
        if (this instanceof Execute) {
            return false;
        }
        return 0;
    }

    private int count(String tableName) throws SQLException {
        UcanaccessConnection conn = this.statement.getConnection();
        try (UcanaccessStatement st = conn.createStatement();){
            int n;
            block12: {
                ResultSet rs = st.executeQuery(String.format("SELECT COUNT(*) FROM %s", tableName));
                try {
                    rs.next();
                    n = rs.getInt(1);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
    }

    private SQLException checkDdlException() {
        UcanaccessConnection conn = this.statement.getConnection();
        try {
            PreparedStatement ps = conn.getHSQLDBConnection().prepareStatement(SQLConverter.convertSQL(this.sql).getSql());
            try {
                throw new SQLFeatureNotSupportedException("Feature not supported");
            }
            catch (Throwable throwable) {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (SQLException _ex) {
            return _ex;
        }
    }

    private Object addDdlCommand() throws SQLException {
        Comparable<Boolean> ret;
        try {
            String constraintName;
            SQLConverter.DDLType ddlType = SQLConverter.getDDLType(this.sql);
            if (ddlType == null) {
                throw this.checkDdlException();
            }
            if (SQLConverter.DDLType.DROP_FOREIGN_KEY.equals((Object)ddlType) && !HibernateSupport.isActive()) {
                throw new UnsupportedOperationException("DROP CONSTRAINT is only supported for Hibernate hbm2ddl.auto \"create\"");
            }
            if (SQLConverter.DDLType.ADD_COLUMN.equals((Object)ddlType) && SQLConverter.couldNeedDefault(ddlType.getColumnDefinition())) {
                String cn = ddlType.getSecondDBObjectName();
                String tn = ddlType.getDBObjectName();
                int count = this.count(ddlType.getDBObjectName());
                if (count > 0) {
                    throw new UcanaccessSQLException(String.format("When adding a new column not null(%s), you must specify a default because table %s already contains one or more records (%d)", cn, tn, count));
                }
            }
            String sql0 = ddlType.equals((Object)SQLConverter.DDLType.ADD_COLUMN) ? SQLConverter.convertSQL(SQLConverter.convertAddColumn(ddlType.getDBObjectName(), ddlType.getSecondDBObjectName(), ddlType.getColumnDefinition())).getSql() : SQLConverter.convertSQL(this.sql).getSql();
            boolean enDis = ddlType.in(SQLConverter.DDLType.ENABLE_AUTOINCREMENT, SQLConverter.DDLType.DISABLE_AUTOINCREMENT);
            this.statement.setEnableDisable(enDis);
            if (enDis) {
                return this.enableDisable(ddlType);
            }
            String ddlExpr = null;
            if (ddlType.in(SQLConverter.DDLType.CREATE_TABLE, SQLConverter.DDLType.CREATE_TABLE_AS_SELECT)) {
                ddlExpr = SQLConverter.convertCreateTable(sql0);
            } else if (ddlType.equals((Object)SQLConverter.DDLType.CREATE_FOREIGN_KEY)) {
                constraintName = ddlType.getSecondDBObjectName();
                if (constraintName == null) {
                    ddlExpr = sql0;
                } else {
                    UcanaccessConnection conn;
                    Metadata mtd;
                    String tableName;
                    if (constraintName.startsWith("[") && constraintName.endsWith("]")) {
                        constraintName = constraintName.substring(1, constraintName.length() - 1);
                    }
                    if ((tableName = ddlType.getDBObjectName()).startsWith("[") && tableName.endsWith("]")) {
                        tableName = tableName.substring(1, tableName.length() - 1);
                    }
                    if ((tableName = (mtd = new Metadata((conn = this.statement.getConnection()).getHSQLDBConnection())).getEscapedTableName(tableName)) == null) {
                        throw new TableNotFoundException(tableName);
                    }
                    Pattern pat = Pattern.compile("\\s+ADD\\s+CONSTRAINT\\s+.*?\\s+FOREIGN\\s+KEY\\s+", 2);
                    ddlExpr = pat.matcher(sql0).replaceFirst(" ADD CONSTRAINT \"" + tableName + "_" + constraintName.toUpperCase(Locale.US) + "\" FOREIGN KEY ");
                }
            } else if (ddlType.equals((Object)SQLConverter.DDLType.DROP_FOREIGN_KEY)) {
                UcanaccessConnection conn;
                Metadata mtd;
                String tableName;
                constraintName = ddlType.getSecondDBObjectName();
                if (constraintName == null) {
                    throw new UcanaccessSQLException();
                }
                if (constraintName.startsWith("[") && constraintName.endsWith("]")) {
                    constraintName = constraintName.substring(1, constraintName.length() - 1);
                }
                if ((tableName = ddlType.getDBObjectName()).startsWith("[") && tableName.endsWith("]")) {
                    tableName = tableName.substring(1, tableName.length() - 1);
                }
                if ((tableName = (mtd = new Metadata((conn = this.statement.getConnection()).getHSQLDBConnection())).getEscapedTableName(tableName)) == null) {
                    throw new TableNotFoundException(tableName);
                }
                Pattern pat = Pattern.compile("\\s+DROP\\s+CONSTRAINT\\s+.*", 2);
                ddlExpr = pat.matcher(sql0).replaceFirst(" DROP CONSTRAINT \"" + tableName + "_" + constraintName.toUpperCase(Locale.US) + "\"");
            } else {
                ddlExpr = sql0;
            }
            ret = this instanceof Execute ? (Comparable<Boolean>)Boolean.valueOf(this.statement.getWrapped().execute(ddlExpr)) : (Comparable<Boolean>)Integer.valueOf(this.statement.getWrapped().executeUpdate(ddlExpr));
            DDLCommandEnlist ddle = new DDLCommandEnlist();
            ddle.enlistDDLCommand(SQLConverter.restoreWorkAroundFunctions(this.sql), ddlType);
        }
        catch (Exception _ex) {
            throw new SQLException(_ex);
        }
        return ret;
    }

    private boolean checkDDL() {
        return SQLConverter.checkDDL(this.sql);
    }

    public Object executeBase() throws SQLException {
        Object retv;
        UcanaccessConnection conn = this.statement.getConnection();
        UcanaccessConnection.setCtxConnection(conn);
        if (this.commandType.equals((Object)CommandType.BATCH)) {
            UcanaccessConnection.setCtxExecId("BATCH_ID");
        } else {
            UcanaccessConnection.setCtxExecId("" + Math.random());
        }
        if (this.checkDDL()) {
            retv = this.addDdlCommand();
        } else {
            try {
                retv = this.executeWrapped();
            }
            catch (SQLException _ex) {
                if (conn.getAutoCommit()) {
                    conn.rollback();
                }
                throw _ex;
            }
        }
        if (conn.getAutoCommit()) {
            conn.commit();
        }
        return retv;
    }

    public abstract Object executeWrapped() throws SQLException;

    ResultSet getWrappedResultSet() {
        return this.resultSet.getWrapped();
    }

    Statement getWrappedStatement() {
        return this.statement.getWrapped();
    }

    void setStatement(UcanaccessStatement _statement) {
        this.statement = _statement;
    }

    protected CommandType getCommandType() {
        return this.commandType;
    }

    void setCommandType(CommandType _commandType) {
        this.commandType = _commandType;
    }

    protected String getSql() {
        return this.sql;
    }

    protected int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    protected String[] getColumnNames() {
        return this.columnNames;
    }

    protected int[] getIndexes() {
        return this.indexes;
    }

    public String toString() {
        return String.format("%s[commandType=%s, sql=%s, autoGeneratedKeys=%d, columnNames=%s, indexes=%s]", new Object[]{this.getClass().getSimpleName(), this.commandType, this.sql, this.autoGeneratedKeys, Arrays.toString(this.columnNames), Arrays.toString(this.indexes)});
    }

    protected static enum CommandType {
        BATCH,
        NO_ARGUMENTS,
        PREPARED_STATEMENT,
        UPDATABLE_RESULTSET,
        WITH_AUTO_GENERATED_KEYS,
        WITH_COLUMNS_NAME,
        WITH_INDEXES;

    }
}

