/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs3.auxiliary.remote.http.server.RemoteHttpCacheServerAttributes;
import org.apache.commons.jcs3.auxiliary.remote.http.server.RemoteHttpCacheService;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.config.PropertySetter;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class RemoteHttpCacheServlet
extends HttpServlet {
    private static final long serialVersionUID = 8752849397531933346L;
    private static final Log log = LogManager.getLog(RemoteHttpCacheServlet.class);
    private static CompositeCacheManager cacheMgr;
    private static ICacheServiceNonLocal<Serializable, Serializable> remoteCacheService;
    private static final StandardSerializer serializer;
    private int serviceCalls;
    private static final int logInterval = 100;

    public void init(ServletConfig config) throws ServletException {
        try {
            cacheMgr = CompositeCacheManager.getInstance();
        }
        catch (CacheException e) {
            throw new ServletException((Throwable)e);
        }
        remoteCacheService = this.createRemoteHttpCacheService(cacheMgr);
        super.init(config);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.incrementServiceCallCount();
        log.debug("Servicing a request. {0}", request);
        RemoteCacheRequest<Serializable, Serializable> remoteRequest = this.readRequest(request);
        RemoteCacheResponse<Object> cacheResponse = this.processRequest(remoteRequest);
        this.writeResponse(response, cacheResponse);
    }

    protected RemoteCacheRequest<Serializable, Serializable> readRequest(HttpServletRequest request) {
        RemoteCacheRequest<Serializable, Serializable> remoteRequest = null;
        try (ServletInputStream inputStream = request.getInputStream();){
            log.debug("After getting input stream and before reading it");
            remoteRequest = this.readRequestFromStream((InputStream)inputStream);
        }
        catch (IOException | ClassNotFoundException e) {
            log.error("Could not get a RemoteHttpCacheRequest object from the input stream.", e);
        }
        return remoteRequest;
    }

    protected RemoteCacheRequest<Serializable, Serializable> readRequestFromStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        return (RemoteCacheRequest)serializer.deSerializeFrom(inputStream, null);
    }

    protected void writeResponse(HttpServletResponse response, RemoteCacheResponse<Object> cacheResponse) {
        try (ServletOutputStream outputStream = response.getOutputStream();){
            response.setContentType("application/octet-stream");
            serializer.serializeTo(cacheResponse, (OutputStream)outputStream);
        }
        catch (IOException e) {
            log.error("Problem writing response. {0}", cacheResponse, e);
        }
    }

    protected RemoteCacheResponse<Object> processRequest(RemoteCacheRequest<Serializable, Serializable> request) {
        RemoteCacheResponse<Object> response = new RemoteCacheResponse<Object>();
        if (request == null) {
            String message = "The request is null. Cannot process";
            log.warn("The request is null. Cannot process");
            response.setSuccess(false);
            response.setErrorMessage("The request is null. Cannot process");
        } else {
            try {
                switch (request.getRequestType()) {
                    case GET: {
                        ICacheElement<Serializable, Serializable> element = remoteCacheService.get(request.getCacheName(), request.getKey(), request.getRequesterId());
                        response.setPayload(element);
                        break;
                    }
                    case GET_MULTIPLE: {
                        Map<Serializable, ICacheElement<Serializable, Serializable>> elementMap = remoteCacheService.getMultiple(request.getCacheName(), request.getKeySet(), request.getRequesterId());
                        if (elementMap != null) {
                            response.setPayload(new HashMap<Serializable, ICacheElement<Serializable, Serializable>>(elementMap));
                        }
                        break;
                    }
                    case GET_MATCHING: {
                        Map<Serializable, ICacheElement<Serializable, Serializable>> elementMapMatching = remoteCacheService.getMatching(request.getCacheName(), request.getPattern(), request.getRequesterId());
                        if (elementMapMatching != null) {
                            response.setPayload(new HashMap<Serializable, ICacheElement<Serializable, Serializable>>(elementMapMatching));
                        }
                        break;
                    }
                    case REMOVE: {
                        remoteCacheService.remove(request.getCacheName(), request.getKey(), request.getRequesterId());
                        break;
                    }
                    case REMOVE_ALL: {
                        remoteCacheService.removeAll(request.getCacheName(), request.getRequesterId());
                        break;
                    }
                    case UPDATE: {
                        remoteCacheService.update(request.getCacheElement(), request.getRequesterId());
                        break;
                    }
                    case ALIVE_CHECK: 
                    case DISPOSE: {
                        response.setSuccess(true);
                        break;
                    }
                    case GET_KEYSET: {
                        Set<Serializable> keys = remoteCacheService.getKeySet(request.getCacheName());
                        response.setPayload(keys);
                        break;
                    }
                    default: {
                        String message = "Unknown event type.  Cannot process " + request;
                        log.warn(message);
                        response.setSuccess(false);
                        response.setErrorMessage(message);
                        break;
                    }
                }
            }
            catch (IOException e) {
                String message = "Problem processing request. " + request + " Error: " + e.getMessage();
                log.error(message, e);
                response.setSuccess(false);
                response.setErrorMessage(message);
            }
        }
        return response;
    }

    protected <K, V> RemoteHttpCacheService<K, V> createRemoteHttpCacheService(ICompositeCacheManager cacheManager) {
        Properties props = cacheManager.getConfigurationProperties();
        ICacheEventLogger cacheEventLogger = this.configureCacheEventLogger(props);
        RemoteHttpCacheServerAttributes attributes = this.configureRemoteHttpCacheServerAttributes(props);
        RemoteHttpCacheService service = new RemoteHttpCacheService(cacheManager, attributes, cacheEventLogger);
        log.info("Created new RemoteHttpCacheService {0}", service);
        return service;
    }

    protected ICacheEventLogger configureCacheEventLogger(Properties props) {
        return AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "jcs.remotehttpcache");
    }

    protected RemoteHttpCacheServerAttributes configureRemoteHttpCacheServerAttributes(Properties prop) {
        RemoteHttpCacheServerAttributes rcsa = new RemoteHttpCacheServerAttributes();
        PropertySetter.setProperties(rcsa, prop, "jcs.remotehttpcache.serverattributes.");
        return rcsa;
    }

    protected void setRemoteCacheService(ICacheServiceNonLocal<Serializable, Serializable> rcs) {
        remoteCacheService = rcs;
    }

    private void incrementServiceCallCount() {
        ++this.serviceCalls;
        if (log.isInfoEnabled() && this.serviceCalls % 100 == 0) {
            log.info("serviceCalls = {0}", this.serviceCalls);
        }
    }

    public void destroy() {
        log.info("Servlet Destroyed, shutting down JCS.");
        cacheMgr.shutDown();
    }

    public String getServletInfo() {
        return "RemoteHttpCacheServlet";
    }

    static {
        serializer = new StandardSerializer();
    }
}

