/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.torque.Column;

public class JdbcTypedValue {
    private int jdbcType;
    private Object value;
    private Column sqlExpression;

    public JdbcTypedValue(Object value, int jdbcType) {
        this.jdbcType = jdbcType;
        this.value = value;
    }

    public JdbcTypedValue(Column sqlExpression) {
        if (sqlExpression == null) {
            throw new IllegalArgumentException("sqlExpression must not be null");
        }
        this.sqlExpression = sqlExpression;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(int jdbcType) {
        if (this.sqlExpression != null) {
            throw new IllegalStateException("jdbcType may not be set if sqlExpression is set");
        }
        this.jdbcType = jdbcType;
    }

    public Object getValue() {
        return this.value;
    }

    public Column getSqlExpression() {
        return this.sqlExpression;
    }

    public void setValue(Object value) {
        if (this.sqlExpression != null) {
            throw new IllegalStateException("value may not be set if sqlExpression is set");
        }
        this.value = value;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder().append(this.jdbcType).append(this.value).append((Object)this.sqlExpression);
        return hashCodeBuilder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcTypedValue other = (JdbcTypedValue)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder().append(this.jdbcType, other.jdbcType).append(this.value, other.value).append((Object)this.sqlExpression, (Object)other.sqlExpression);
        return equalsBuilder.isEquals();
    }

    public String toString() {
        if (this.sqlExpression == null) {
            return "JdbcTypedValue [jdbcType=" + this.jdbcType + ", value=" + String.valueOf(this.value) + "]";
        }
        return "JdbcTypedValue [sqlExpression=" + String.valueOf(this.sqlExpression) + "]";
    }
}

