/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteUtils == null ? (class$org$apache$jcs$auxiliary$remote$RemoteUtils = RemoteUtils.class$("org.apache.jcs.auxiliary.remote.RemoteUtils")) : class$org$apache$jcs$auxiliary$remote$RemoteUtils));
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteUtils;

    private RemoteUtils() {
    }

    public static int createRegistry(int port) throws RemoteException {
        if (log.isInfoEnabled()) {
            log.info((Object)"createRegistry> setting security manager");
        }
        System.setSecurityManager(new RMISecurityManager());
        if (port < 1024) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Port chosen was less than 1024, will use default [1099] instead.");
            }
            port = 1099;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("createRegistry> creating registry on port [" + port + "]"));
        }
        LocateRegistry.createRegistry(port);
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProps(String propFile) throws IOException {
        InputStream is = (class$org$apache$jcs$auxiliary$remote$RemoteUtils == null ? (class$org$apache$jcs$auxiliary$remote$RemoteUtils = RemoteUtils.class$("org.apache.jcs.auxiliary.remote.RemoteUtils")) : class$org$apache$jcs$auxiliary$remote$RemoteUtils).getResourceAsStream(propFile);
        Properties props = new Properties();
        try {
            props.load(is);
            if (log.isDebugEnabled()) {
                log.debug((Object)("props.size=" + props.size()));
            }
            if (log.isDebugEnabled()) {
                if (props != null) {
                    Enumeration<Object> en = props.keys();
                    StringBuffer buf = new StringBuffer();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        buf.append("\n" + key + " = " + props.getProperty(key));
                    }
                    log.debug((Object)buf.toString());
                } else {
                    log.debug((Object)"props is null");
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error loading remote properties, for file name [" + propFile + "]"), (Throwable)ex);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

