/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.positional.PositionalSegment;
import org.apache.datasketches.filters.bloomfilter.BitArray;
import org.apache.datasketches.filters.bloomfilter.HeapBitArray;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapBitArrayTest {
    @Test
    public void createBitArrayTest() {
        HeapBitArray ba = new HeapBitArray(119L);
        Assert.assertEquals((long)ba.getCapacity(), (long)128L);
        Assert.assertEquals((int)ba.getArrayLength(), (int)2);
        Assert.assertEquals((long)ba.getNumBitsSet(), (long)0L);
        Assert.assertTrue((boolean)ba.isEmpty());
        Assert.assertFalse((boolean)ba.hasMemorySegment());
        Assert.assertFalse((boolean)ba.isOffHeap());
        Assert.assertFalse((boolean)ba.isReadOnly());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void createNegativeSizeBitArrayTest() {
        new HeapBitArray(-64L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void createTooLargeBitArrayTest() {
        new HeapBitArray(0x1FFFFFFFC1L);
    }

    @Test
    public void basicOperationTest() {
        HeapBitArray ba = new HeapBitArray(128L);
        Assert.assertEquals((boolean)ba.getAndSetBit(1L), (boolean)false);
        Assert.assertEquals((boolean)ba.getAndSetBit(2L), (boolean)false);
        for (int i = 4; i < 64; i <<= 1) {
            ba.getAndSetBit((long)(64 + i));
        }
        Assert.assertEquals((long)ba.getNumBitsSet(), (long)6L);
        Assert.assertEquals((boolean)ba.getBit(68L), (boolean)true);
        Assert.assertFalse((boolean)ba.isEmpty());
        Assert.assertFalse((boolean)ba.getBit(5L));
        ba.setBit(5L);
        Assert.assertTrue((boolean)ba.getAndSetBit(5L));
        Assert.assertEquals((long)ba.getNumBitsSet(), (long)7L);
        ba.reset();
        Assert.assertTrue((boolean)ba.isEmpty());
        Assert.assertEquals((long)ba.getNumBitsSet(), (long)0L);
        Assert.assertTrue((String.valueOf(ba).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void bitAddresOutOfBoundsTest() {
        HeapBitArray ba = new HeapBitArray(1024L);
        Assert.assertThrows(ArrayIndexOutOfBoundsException.class, () -> ba.getBit(-10L));
        Assert.assertThrows(ArrayIndexOutOfBoundsException.class, () -> ba.getBit(2048L));
        Assert.assertThrows(ArrayIndexOutOfBoundsException.class, () -> ba.setBit(-20L));
        Assert.assertThrows(ArrayIndexOutOfBoundsException.class, () -> ba.setBit(4096L));
        Assert.assertThrows(ArrayIndexOutOfBoundsException.class, () -> ba.getAndSetBit(-30L));
        Assert.assertThrows(ArrayIndexOutOfBoundsException.class, () -> ba.getAndSetBit(8192L));
    }

    @Test
    public void inversionTest() {
        int numBits = 1024;
        HeapBitArray ba = new HeapBitArray(1024L);
        for (int i = 0; i < 1024; i += 128) {
            ba.getAndSetBit((long)i);
        }
        Assert.assertTrue((boolean)ba.getBit(0L));
        long numSet = ba.getNumBitsSet();
        ba.invert();
        Assert.assertEquals((long)ba.getNumBitsSet(), (long)(1024L - numSet));
        Assert.assertFalse((boolean)ba.getBit(0L));
        ba.setBit(0L);
        ba.invert();
        Assert.assertEquals((long)ba.getNumBitsSet(), (long)(numSet - 1L));
        Assert.assertFalse((boolean)ba.getBit(0L));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void invalidUnionTest() {
        HeapBitArray ba = new HeapBitArray(128L);
        ba.union((BitArray)new HeapBitArray(64L));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void invalidIntersectionTest() {
        HeapBitArray ba = new HeapBitArray(128L);
        ba.intersect((BitArray)new HeapBitArray(64L));
    }

    @Test
    public void validUnionAndIntersectionTest() {
        HeapBitArray ba1 = new HeapBitArray(64L);
        HeapBitArray ba2 = new HeapBitArray(64L);
        HeapBitArray ba3 = new HeapBitArray(64L);
        int n = 10;
        for (int i = 0; i < 10; ++i) {
            ba1.getAndSetBit((long)i);
            ba2.getAndSetBit((long)(i + 5));
            ba3.getAndSetBit((long)(2 * i));
        }
        Assert.assertEquals((long)ba1.getNumBitsSet(), (long)10L);
        Assert.assertEquals((long)ba2.getNumBitsSet(), (long)10L);
        Assert.assertEquals((long)ba3.getNumBitsSet(), (long)10L);
        ba1.intersect((BitArray)ba2);
        Assert.assertEquals((long)ba1.getNumBitsSet(), (long)5L);
        ba3.union((BitArray)ba2);
        Assert.assertEquals((long)ba3.getNumBitsSet(), (long)15L);
    }

    @Test
    public void serializeEmptyTest() {
        HeapBitArray ba = new HeapBitArray(64L);
        byte[] arr = new byte[(int)ba.getSerializedSizeBytes()];
        PositionalSegment posSeg = PositionalSegment.wrap((MemorySegment)MemorySegment.ofArray(arr));
        ba.writeToSegmentAsStream(posSeg);
        posSeg.resetPosition();
        HeapBitArray newBA = HeapBitArray.heapify((PositionalSegment)posSeg, (boolean)true);
        Assert.assertEquals((int)newBA.getArrayLength(), (int)ba.getArrayLength());
        Assert.assertEquals((long)newBA.getCapacity(), (long)ba.getCapacity());
        Assert.assertEquals((long)newBA.getNumBitsSet(), (long)ba.getNumBitsSet());
        Assert.assertTrue((boolean)newBA.isEmpty());
    }

    @Test
    public void serializeNonEmptyTest() {
        long n = 8192L;
        HeapBitArray ba = new HeapBitArray(8192L);
        int i = 0;
        while ((long)i < 8192L) {
            ba.getAndSetBit((long)i);
            i += 3;
        }
        byte[] arr = new byte[(int)ba.getSerializedSizeBytes()];
        PositionalSegment posSeg = PositionalSegment.wrap((MemorySegment)MemorySegment.ofArray(arr));
        ba.writeToSegmentAsStream(posSeg);
        posSeg.resetPosition();
        HeapBitArray newBA = HeapBitArray.heapify((PositionalSegment)posSeg, (boolean)false);
        Assert.assertEquals((int)newBA.getArrayLength(), (int)ba.getArrayLength());
        Assert.assertEquals((long)newBA.getCapacity(), (long)ba.getCapacity());
        Assert.assertEquals((long)newBA.getNumBitsSet(), (long)ba.getNumBitsSet());
        Assert.assertFalse((boolean)newBA.isEmpty());
    }
}

