/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.runtime1.dpath.BinaryOpMixin;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.NumericOp;
import org.apache.daffodil.runtime1.dpath.NumericOperator$;
import org.apache.daffodil.runtime1.dpath.RecipeOp;
import org.apache.daffodil.runtime1.infoset.DINode;
import org.apache.daffodil.runtime1.infoset.DataValue;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class NumericOperator
extends RecipeOp
implements BinaryOpMixin,
Product {
    private final NumericOp nop;
    private final CompiledDPath left;
    private final CompiledDPath right;

    public static NumericOperator apply(NumericOp numericOp, CompiledDPath compiledDPath, CompiledDPath compiledDPath2) {
        return NumericOperator$.MODULE$.apply(numericOp, compiledDPath, compiledDPath2);
    }

    public static NumericOperator fromProduct(Product product) {
        return NumericOperator$.MODULE$.fromProduct(product);
    }

    public static NumericOperator unapply(NumericOperator numericOperator) {
        return NumericOperator$.MODULE$.unapply(numericOperator);
    }

    public NumericOperator(NumericOp nop, CompiledDPath left, CompiledDPath right) {
        this.nop = nop;
        this.left = left;
        this.right = right;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 1663151305, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof NumericOperator)) return false;
        NumericOperator numericOperator = (NumericOperator)object;
        NumericOp numericOp = this.nop();
        NumericOp numericOp2 = numericOperator.nop();
        if (numericOp == null) {
            if (numericOp2 != null) {
                return false;
            }
        } else if (!numericOp.equals(numericOp2)) return false;
        CompiledDPath compiledDPath = this.left();
        CompiledDPath compiledDPath2 = numericOperator.left();
        if (compiledDPath == null) {
            if (compiledDPath2 != null) {
                return false;
            }
        } else if (!compiledDPath.equals(compiledDPath2)) return false;
        CompiledDPath compiledDPath3 = this.right();
        CompiledDPath compiledDPath4 = numericOperator.right();
        if (compiledDPath3 == null) {
            if (compiledDPath4 != null) {
                return false;
            }
        } else if (!compiledDPath3.equals(compiledDPath4)) return false;
        if (!numericOperator.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof NumericOperator;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "NumericOperator";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "nop";
            }
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public NumericOp nop() {
        return this.nop;
    }

    @Override
    public CompiledDPath left() {
        return this.left;
    }

    @Override
    public CompiledDPath right() {
        return this.right;
    }

    @Override
    public String op() {
        return Misc$.MODULE$.getNameFromClass(this.nop());
    }

    @Override
    public void run(DState dstate) {
        DINode savedNode = dstate.currentNode();
        this.left().run(dstate);
        Object object = dstate.currentValue();
        Object leftValue = new DataValue(DataValue$.MODULE$.getNonNullable$extension(object)).v();
        dstate.setCurrentNode(savedNode);
        this.right().run(dstate);
        Object object2 = dstate.currentValue();
        Object rightValue = new DataValue(DataValue$.MODULE$.getNonNullable$extension(object2)).v();
        Number result = this.nop().operate(leftValue, rightValue);
        dstate.setCurrentValue(result);
    }

    public NumericOperator copy(NumericOp nop, CompiledDPath left, CompiledDPath right) {
        return new NumericOperator(nop, left, right);
    }

    public NumericOp copy$default$1() {
        return this.nop();
    }

    public CompiledDPath copy$default$2() {
        return this.left();
    }

    public CompiledDPath copy$default$3() {
        return this.right();
    }

    public NumericOp _1() {
        return this.nop();
    }

    public CompiledDPath _2() {
        return this.left();
    }

    public CompiledDPath _3() {
        return this.right();
    }
}

