/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.api;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.rat.utils.Log;

public enum EnvVar {
    RAT_NO_GIT_GLOBAL_IGNORE("Ignore global ignore file when processing GIT ignore files."),
    RAT_DECOMPOSE_MATCHER_ON_USE("Log the decomposition of matchers on use. Messages will be logged at the minimum log level currently enabled."),
    XDG_CONFIG_HOME("Where user-specific configurations are written. Generally defaults to $HOME/.config. Only needs to be set if it has been changed on the system."),
    HOME("The current user's home directory."),
    RAT_DEFAULT_LOG_LEVEL("The default log level for the command line logger. Should be one of: " + Arrays.stream(Log.Level.values()).map(Enum::name).collect(Collectors.joining(", ")) + ".");

    private final String documentation;

    private EnvVar(String documentation) {
        this.documentation = documentation;
    }

    public String documentation() {
        return this.documentation;
    }

    public boolean isSet() {
        return this.getValue() != null;
    }

    public String getValue() {
        return System.getenv(this.name());
    }
}

