/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ode;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MathIllegalStateException;
import org.apache.commons.math4.legacy.exception.MaxCountExceededException;
import org.apache.commons.math4.legacy.exception.NoBracketingException;
import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.legacy.ode.AbstractIntegrator;
import org.apache.commons.math4.legacy.ode.EquationsMapper;
import org.apache.commons.math4.legacy.ode.ExpandableStatefulODE;
import org.apache.commons.math4.legacy.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math4.legacy.ode.FirstOrderIntegrator;
import org.apache.commons.math4.legacy.ode.ODEIntegrator;
import org.apache.commons.math4.legacy.ode.nonstiff.AdaptiveStepsizeIntegrator;
import org.apache.commons.math4.legacy.ode.nonstiff.DormandPrince853Integrator;
import org.apache.commons.math4.legacy.ode.sampling.StepHandler;
import org.apache.commons.math4.legacy.ode.sampling.StepInterpolator;

public abstract class MultistepIntegrator
extends AdaptiveStepsizeIntegrator {
    protected double[] scaled;
    protected Array2DRowRealMatrix nordsieck;
    private FirstOrderIntegrator starter;
    private final int nSteps;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected MultistepIntegrator(String name, int nSteps, int order, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws NumberIsTooSmallException {
        super(name, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        if (nSteps < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, (Number)nSteps, (Number)2, true);
        }
        this.starter = new DormandPrince853Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(JdkMath.pow((double)2.0, (double)(-this.exp)));
    }

    protected MultistepIntegrator(String name, int nSteps, int order, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(name, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.starter = new DormandPrince853Integrator(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(JdkMath.pow((double)2.0, (double)(-this.exp)));
    }

    public ODEIntegrator getStarterIntegrator() {
        return this.starter;
    }

    public void setStarterIntegrator(FirstOrderIntegrator starterIntegrator) {
        this.starter = starterIntegrator;
    }

    protected void start(double t0, double[] y0, double t) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.starter.clearEventHandlers();
        this.starter.clearStepHandlers();
        this.starter.addStepHandler(new NordsieckInitializer((this.nSteps + 3) / 2, y0.length));
        try {
            if (this.starter instanceof AbstractIntegrator) {
                ((AbstractIntegrator)this.starter).integrate(this.getExpandable(), t);
            } else {
                this.starter.integrate(new FirstOrderDifferentialEquations(){

                    @Override
                    public int getDimension() {
                        return MultistepIntegrator.this.getExpandable().getTotalDimension();
                    }

                    @Override
                    public void computeDerivatives(double t, double[] y, double[] yDot) {
                        MultistepIntegrator.this.getExpandable().computeDerivatives(t, y, yDot);
                    }
                }, t0, y0, t, new double[y0.length]);
            }
            throw new MathIllegalStateException((Localizable)LocalizedFormats.MULTISTEP_STARTER_STOPPED_EARLY, new Object[0]);
        }
        catch (InitializationCompletedMarkerException icme) {
            this.getCounter().increment(this.starter.getEvaluations());
            this.starter.clearStepHandlers();
            return;
        }
    }

    protected abstract Array2DRowRealMatrix initializeHighOrderDerivatives(double var1, double[] var3, double[][] var4, double[][] var5);

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double minReduction) {
        this.minReduction = minReduction;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double safety) {
        this.safety = safety;
    }

    public int getNSteps() {
        return this.nSteps;
    }

    protected double computeStepGrowShrinkFactor(double error) {
        return JdkMath.min((double)this.maxGrowth, (double)JdkMath.max((double)this.minReduction, (double)(this.safety * JdkMath.pow((double)error, (double)this.exp))));
    }

    private static class InitializationCompletedMarkerException
    extends RuntimeException {
        private static final long serialVersionUID = -1914085471038046418L;

        InitializationCompletedMarkerException() {
            super((Throwable)null);
        }
    }

    private class NordsieckInitializer
    implements StepHandler {
        private int count = 0;
        private final double[] t;
        private final double[][] y;
        private final double[][] yDot;

        NordsieckInitializer(int nbStartPoints, int n) {
            this.t = new double[nbStartPoints];
            this.y = new double[nbStartPoints][n];
            this.yDot = new double[nbStartPoints][n];
        }

        @Override
        public void handleStep(StepInterpolator interpolator, boolean isLast) throws MaxCountExceededException {
            int index;
            EquationsMapper primary;
            ExpandableStatefulODE expandable;
            double prev = interpolator.getPreviousTime();
            double curr = interpolator.getCurrentTime();
            if (this.count == 0) {
                interpolator.setInterpolatedTime(prev);
                this.t[0] = prev;
                expandable = MultistepIntegrator.this.getExpandable();
                primary = expandable.getPrimaryMapper();
                primary.insertEquationData(interpolator.getInterpolatedState(), this.y[this.count]);
                primary.insertEquationData(interpolator.getInterpolatedDerivatives(), this.yDot[this.count]);
                index = 0;
                for (EquationsMapper secondary : expandable.getSecondaryMappers()) {
                    secondary.insertEquationData(interpolator.getInterpolatedSecondaryState(index), this.y[this.count]);
                    secondary.insertEquationData(interpolator.getInterpolatedSecondaryDerivatives(index), this.yDot[this.count]);
                    ++index;
                }
            }
            ++this.count;
            interpolator.setInterpolatedTime(curr);
            this.t[this.count] = curr;
            expandable = MultistepIntegrator.this.getExpandable();
            primary = expandable.getPrimaryMapper();
            primary.insertEquationData(interpolator.getInterpolatedState(), this.y[this.count]);
            primary.insertEquationData(interpolator.getInterpolatedDerivatives(), this.yDot[this.count]);
            index = 0;
            for (EquationsMapper secondary : expandable.getSecondaryMappers()) {
                secondary.insertEquationData(interpolator.getInterpolatedSecondaryState(index), this.y[this.count]);
                secondary.insertEquationData(interpolator.getInterpolatedSecondaryDerivatives(index), this.yDot[this.count]);
                ++index;
            }
            if (this.count == this.t.length - 1) {
                MultistepIntegrator.this.stepStart = this.t[0];
                MultistepIntegrator.this.stepSize = (this.t[this.t.length - 1] - this.t[0]) / (double)(this.t.length - 1);
                MultistepIntegrator.this.scaled = (double[])this.yDot[0].clone();
                int j = 0;
                while (j < MultistepIntegrator.this.scaled.length) {
                    int n = j++;
                    MultistepIntegrator.this.scaled[n] = MultistepIntegrator.this.scaled[n] * MultistepIntegrator.this.stepSize;
                }
                MultistepIntegrator.this.nordsieck = MultistepIntegrator.this.initializeHighOrderDerivatives(MultistepIntegrator.this.stepSize, this.t, this.y, this.yDot);
                throw new InitializationCompletedMarkerException();
            }
        }

        @Override
        public void init(double t0, double[] y0, double time) {
        }
    }

    @Deprecated
    public static interface NordsieckTransformer {
        public Array2DRowRealMatrix initializeHighOrderDerivatives(double var1, double[] var3, double[][] var4, double[][] var5);
    }
}

