/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ode;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.core.Field;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.core.RealFieldElement;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MathIllegalStateException;
import org.apache.commons.math4.legacy.exception.MaxCountExceededException;
import org.apache.commons.math4.legacy.exception.NoBracketingException;
import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.linear.Array2DRowFieldMatrix;
import org.apache.commons.math4.legacy.ode.FieldEquationsMapper;
import org.apache.commons.math4.legacy.ode.FieldExpandableODE;
import org.apache.commons.math4.legacy.ode.FieldODEState;
import org.apache.commons.math4.legacy.ode.FieldODEStateAndDerivative;
import org.apache.commons.math4.legacy.ode.FirstOrderFieldIntegrator;
import org.apache.commons.math4.legacy.ode.nonstiff.AdaptiveStepsizeFieldIntegrator;
import org.apache.commons.math4.legacy.ode.nonstiff.DormandPrince853FieldIntegrator;
import org.apache.commons.math4.legacy.ode.sampling.FieldStepHandler;
import org.apache.commons.math4.legacy.ode.sampling.FieldStepInterpolator;

public abstract class MultistepFieldIntegrator<T extends RealFieldElement<T>>
extends AdaptiveStepsizeFieldIntegrator<T> {
    protected T[] scaled;
    protected Array2DRowFieldMatrix<T> nordsieck;
    private FirstOrderFieldIntegrator<T> starter;
    private final int nSteps;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected MultistepFieldIntegrator(Field<T> field, String name, int nSteps, int order, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws NumberIsTooSmallException {
        super(field, name, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        if (nSteps < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, (Number)nSteps, (Number)2, true);
        }
        this.starter = new DormandPrince853FieldIntegrator<T>(field, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(JdkMath.pow((double)2.0, (double)(-this.exp)));
    }

    protected MultistepFieldIntegrator(Field<T> field, String name, int nSteps, int order, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(field, name, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.starter = new DormandPrince853FieldIntegrator<T>(field, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(JdkMath.pow((double)2.0, (double)(-this.exp)));
    }

    public FirstOrderFieldIntegrator<T> getStarterIntegrator() {
        return this.starter;
    }

    public void setStarterIntegrator(FirstOrderFieldIntegrator<T> starterIntegrator) {
        this.starter = starterIntegrator;
    }

    protected void start(FieldExpandableODE<T> equations, FieldODEState<T> initialState, T t) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.starter.clearEventHandlers();
        this.starter.clearStepHandlers();
        this.starter.addStepHandler(new FieldNordsieckInitializer(equations.getMapper(), (this.nSteps + 3) / 2));
        try {
            this.starter.integrate(equations, initialState, t);
            throw new MathIllegalStateException((Localizable)LocalizedFormats.MULTISTEP_STARTER_STOPPED_EARLY, new Object[0]);
        }
        catch (InitializationCompletedMarkerException icme) {
            this.getEvaluationsCounter().increment(this.starter.getEvaluations());
            this.starter.clearStepHandlers();
            return;
        }
    }

    protected abstract Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T var1, T[] var2, T[][] var3, T[][] var4);

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double minReduction) {
        this.minReduction = minReduction;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double safety) {
        this.safety = safety;
    }

    public int getNSteps() {
        return this.nSteps;
    }

    protected void rescale(T newStepSize) {
        RealFieldElement ratio = (RealFieldElement)newStepSize.divide(this.getStepSize());
        for (int i = 0; i < this.scaled.length; ++i) {
            this.scaled[i] = (RealFieldElement)this.scaled[i].multiply((Object)ratio);
        }
        RealFieldElement[][] nData = (RealFieldElement[][])this.nordsieck.getDataRef();
        RealFieldElement power = ratio;
        for (int i = 0; i < nData.length; ++i) {
            power = (RealFieldElement)power.multiply((Object)ratio);
            RealFieldElement[] nDataI = nData[i];
            for (int j = 0; j < nDataI.length; ++j) {
                nDataI[j] = (RealFieldElement)nDataI[j].multiply((Object)power);
            }
        }
        this.setStepSize(newStepSize);
    }

    protected T computeStepGrowShrinkFactor(T error) {
        return (T)RealFieldElement.min((RealFieldElement)((RealFieldElement)((RealFieldElement)error.getField().getZero()).add(this.maxGrowth)), (RealFieldElement)RealFieldElement.max((RealFieldElement)((RealFieldElement)((RealFieldElement)error.getField().getZero()).add(this.minReduction)), (RealFieldElement)((RealFieldElement)((RealFieldElement)error.pow(this.exp)).multiply(this.safety))));
    }

    private static class InitializationCompletedMarkerException
    extends RuntimeException {
        private static final long serialVersionUID = -1914085471038046418L;

        InitializationCompletedMarkerException() {
            super((Throwable)null);
        }
    }

    private class FieldNordsieckInitializer
    implements FieldStepHandler<T> {
        private final FieldEquationsMapper<T> mapper;
        private int count;
        private FieldODEStateAndDerivative<T> savedStart;
        private final T[] t;
        private final T[][] y;
        private final T[][] yDot;

        FieldNordsieckInitializer(FieldEquationsMapper<T> mapper, int nbStartPoints) {
            this.mapper = mapper;
            this.count = 0;
            this.t = (RealFieldElement[])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), (int)nbStartPoints);
            this.y = (RealFieldElement[][])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), (int)nbStartPoints, (int)-1);
            this.yDot = (RealFieldElement[][])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), (int)nbStartPoints, (int)-1);
        }

        @Override
        public void handleStep(FieldStepInterpolator<T> interpolator, boolean isLast) throws MaxCountExceededException {
            if (this.count == 0) {
                FieldODEStateAndDerivative prev = interpolator.getPreviousState();
                this.savedStart = prev;
                this.t[this.count] = prev.getTime();
                this.y[this.count] = this.mapper.mapState(prev);
                this.yDot[this.count] = this.mapper.mapDerivative(prev);
            }
            ++this.count;
            FieldODEStateAndDerivative curr = interpolator.getCurrentState();
            this.t[this.count] = curr.getTime();
            this.y[this.count] = this.mapper.mapState(curr);
            this.yDot[this.count] = this.mapper.mapDerivative(curr);
            if (this.count == this.t.length - 1) {
                MultistepFieldIntegrator.this.setStepSize((RealFieldElement)((RealFieldElement)this.t[this.t.length - 1].subtract(this.t[0])).divide((double)(this.t.length - 1)));
                MultistepFieldIntegrator.this.scaled = (RealFieldElement[])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), (int)this.yDot[0].length);
                for (int j = 0; j < MultistepFieldIntegrator.this.scaled.length; ++j) {
                    MultistepFieldIntegrator.this.scaled[j] = (RealFieldElement)this.yDot[0][j].multiply(MultistepFieldIntegrator.this.getStepSize());
                }
                MultistepFieldIntegrator.this.nordsieck = MultistepFieldIntegrator.this.initializeHighOrderDerivatives((RealFieldElement)MultistepFieldIntegrator.this.getStepSize(), (RealFieldElement[])this.t, (RealFieldElement[][])this.y, (RealFieldElement[][])this.yDot);
                MultistepFieldIntegrator.this.setStepStart(this.savedStart);
                throw new InitializationCompletedMarkerException();
            }
        }

        @Override
        public void init(FieldODEStateAndDerivative<T> initialState, T finalTime) {
        }
    }
}

