/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.BasicNodeSet;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.TestMixedModelBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Element;

public class BasicNodeSetTest
extends AbstractJXPathTest {
    protected JXPathContext context;
    protected BasicNodeSet nodeSet;

    protected void addPointers(String xpath) {
        Iterator iter = this.context.iteratePointers(xpath);
        while (iter.hasNext()) {
            this.nodeSet.add((Pointer)iter.next());
        }
        this.nudge();
    }

    protected void assertElementNames(List names, List elements) {
        Assertions.assertEquals((int)names.size(), (int)elements.size());
        Iterator nameIter = names.iterator();
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            Assertions.assertEquals(nameIter.next(), (Object)((Element)elementIter.next()).getTagName());
        }
    }

    protected void assertElementValues(List values, List elements) {
        Assertions.assertEquals((int)values.size(), (int)elements.size());
        Iterator valueIter = values.iterator();
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            Assertions.assertEquals(valueIter.next(), (Object)((Element)elementIter.next()).getFirstChild().getNodeValue());
        }
    }

    protected void nudge() {
        this.nodeSet.getPointers();
        this.nodeSet.getValues();
        this.nodeSet.getNodes();
    }

    protected void removePointers(String xpath) {
        Iterator iter = this.context.iteratePointers(xpath);
        while (iter.hasNext()) {
            this.nodeSet.remove((Pointer)iter.next());
        }
        this.nudge();
    }

    @Override
    @BeforeEach
    protected void setUp() throws Exception {
        super.setUp();
        this.context = JXPathContext.newContext((Object)new TestMixedModelBean());
        this.nodeSet = new BasicNodeSet();
    }

    @Test
    public void testAdd() {
        this.addPointers("/bean/integers");
        Assertions.assertEquals((Object)BasicNodeSetTest.list("/bean/integers[1]", "/bean/integers[2]", "/bean/integers[3]", "/bean/integers[4]").toString(), (Object)this.nodeSet.getPointers().toString());
        Assertions.assertEquals((Object)BasicNodeSetTest.list(1, 2, 3, 4), (Object)this.nodeSet.getValues());
        Assertions.assertEquals((Object)BasicNodeSetTest.list(1, 2, 3, 4), (Object)this.nodeSet.getNodes());
    }

    @Test
    public void testNodes() {
        this.addPointers("/document/vendor/contact");
        Assertions.assertEquals((Object)BasicNodeSetTest.list("/document/vendor[1]/contact[1]", "/document/vendor[1]/contact[2]", "/document/vendor[1]/contact[3]", "/document/vendor[1]/contact[4]").toString(), (Object)this.nodeSet.getPointers().toString());
        Assertions.assertEquals((Object)BasicNodeSetTest.list("John", "Jack", "Jim", "Jack Black"), (Object)this.nodeSet.getValues());
        this.assertElementNames(BasicNodeSetTest.list("contact", "contact", "contact", "contact"), this.nodeSet.getNodes());
        this.assertElementValues(BasicNodeSetTest.list("John", "Jack", "Jim", "Jack Black"), this.nodeSet.getNodes());
    }

    @Test
    public void testRemove() {
        this.addPointers("/bean/integers");
        this.removePointers("/bean/integers[4]");
        Assertions.assertEquals((Object)BasicNodeSetTest.list("/bean/integers[1]", "/bean/integers[2]", "/bean/integers[3]").toString(), (Object)this.nodeSet.getPointers().toString());
        Assertions.assertEquals((Object)BasicNodeSetTest.list(1, 2, 3), (Object)this.nodeSet.getValues());
        Assertions.assertEquals((Object)BasicNodeSetTest.list(1, 2, 3), (Object)this.nodeSet.getNodes());
    }
}

