/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.List;

import org.apache.camel.component.fhir.api.FhirSearch;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;
import static org.apache.camel.support.component.ApiMethodArg.setter;

/**
 * Camel {@link ApiMethod} Enumeration for org.apache.camel.component.fhir.api.FhirSearch
 */
public enum FhirSearchApiMethod implements ApiMethod {

    SEARCH_BY_RESOURCE(
        org.hl7.fhir.instance.model.api.IBaseBundle.class,
        "searchByResource",
        arg("resourceName", String.class),
        arg("searchParameters", java.util.Map.class),
        arg("searchStyle", ca.uhn.fhir.rest.api.SearchStyleEnum.class),
        arg("extraParameters", java.util.Map.class)),

    SEARCH_BY_URL(
        org.hl7.fhir.instance.model.api.IBaseBundle.class,
        "searchByUrl",
        arg("url", String.class),
        arg("extraParameters", java.util.Map.class));

    private final ApiMethod apiMethod;

    FhirSearchApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(FhirSearch.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<String> getSetterArgNames() { return apiMethod.getSetterArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
