/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.util.resource.ResourceFilter;
import org.opensaml.xml.util.DatatypeHelper;

public class PropertyReplacementResourceFilter
implements ResourceFilter {
    private File propertyFilePath;

    public PropertyReplacementResourceFilter(File propertyFile) {
        if (propertyFile == null) {
            throw new IllegalArgumentException("Property file may not be null");
        }
        this.propertyFilePath = propertyFile;
    }

    public InputStream applyFilter(InputStream resource) throws ResourceException {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(this.propertyFilePath));
        }
        catch (IOException e) {
            throw new ResourceException("Unable to read property file", e);
        }
        if (props.isEmpty()) {
            return resource;
        }
        try {
            String resourceString = DatatypeHelper.inputstreamToString((InputStream)resource, null);
            Iterator keyItr = (Iterator)((Object)props.propertyNames());
            while (keyItr.hasNext()) {
                String key = (String)keyItr.next();
                resourceString = resourceString.replace("${" + key + "}", props.getProperty(key));
            }
            resourceString.trim();
            return new ByteArrayInputStream(resourceString.getBytes());
        }
        catch (IOException e) {
            throw new ResourceException("Unable to read contents of resource", e);
        }
    }
}

