/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.language.bean.BeanLanguage;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.processor.DefaultExchangeFormatter;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.TokenPairExpressionIterator;
import org.apache.camel.support.TokenXMLExpressionIterator;
import org.apache.camel.support.XMLTokenExpressionIterator;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.GroupIterator;
import org.apache.camel.util.GroupTokenIterator;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.Scanner;
import org.apache.camel.util.SkipIterator;
import org.apache.camel.util.StringHelper;

public final class ExpressionBuilder {
    private static final Pattern OFFSET_PATTERN = Pattern.compile("([+-])([^+-]+)");

    private ExpressionBuilder() {
    }

    public static Expression attachmentObjectsExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getAttachmentObjects();
            }

            public String toString() {
                return "attachmentObjects";
            }
        };
    }

    public static Expression attachmentObjectValuesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getAttachmentObjects().values();
            }

            public String toString() {
                return "attachmentObjects";
            }
        };
    }

    public static Expression attachmentsExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getAttachments();
            }

            public String toString() {
                return "attachments";
            }
        };
    }

    public static Expression attachmentValuesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getAttachments().values();
            }

            public String toString() {
                return "attachments";
            }
        };
    }

    public static Expression headerExpression(final String headerName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = ExpressionBuilder.simpleExpression(headerName).evaluate(exchange, String.class);
                Object header = exchange.getIn().getHeader(name);
                if (header == null) {
                    header = exchange.getProperty(name);
                }
                return header;
            }

            public String toString() {
                return "header(" + headerName + ")";
            }
        };
    }

    public static <T> Expression headerExpression(final String headerName, final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = ExpressionBuilder.simpleExpression(headerName).evaluate(exchange, String.class);
                Object header = exchange.getIn().getHeader(name, type);
                if (header == null) {
                    header = exchange.getProperty(name, type);
                }
                return header;
            }

            public String toString() {
                return "headerAs(" + headerName + ", " + type + ")";
            }
        };
    }

    public static Expression headerExpression(final String headerName, final String typeName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text;
                try {
                    text = ExpressionBuilder.simpleExpression(typeName).evaluate(exchange, String.class);
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
                text = ExpressionBuilder.simpleExpression(headerName).evaluate(exchange, String.class);
                Object header = exchange.getIn().getHeader(text, type);
                if (header == null) {
                    header = exchange.getProperty(text, type);
                }
                return header;
            }

            public String toString() {
                return "headerAs(" + headerName + ", " + typeName + ")";
            }
        };
    }

    public static Expression headersOgnlExpression(String ognl) {
        return new KeyedOgnlExpressionAdapter(ognl, "headerOgnl(" + ognl + ")", new KeyedOgnlExpressionAdapter.KeyedEntityRetrievalStrategy(){

            @Override
            public Object getKeyedEntity(Exchange exchange, String key) {
                String text = ExpressionBuilder.simpleExpression(key).evaluate(exchange, String.class);
                return exchange.getIn().getHeader(text);
            }
        });
    }

    public static Expression headersExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeaders();
            }

            public String toString() {
                return "headers";
            }
        };
    }

    public static Expression outHeaderExpression(final String headerName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (!exchange.hasOut()) {
                    return null;
                }
                String text = ExpressionBuilder.simpleExpression(headerName).evaluate(exchange, String.class);
                Message out = exchange.getOut();
                Object header = out.getHeader(text);
                if (header == null) {
                    header = exchange.getProperty(text);
                }
                return header;
            }

            public String toString() {
                return "outHeader(" + headerName + ")";
            }
        };
    }

    public static Expression outHeadersExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (ExchangeHelper.isOutCapable(exchange)) {
                    return exchange.getOut().getHeaders();
                }
                return null;
            }

            public String toString() {
                return "outHeaders";
            }
        };
    }

    public static Expression exchangePatternExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getPattern();
            }

            public String toString() {
                return "exchangePattern";
            }
        };
    }

    public static Expression exchangeExceptionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                return exception;
            }

            public String toString() {
                return "exchangeException";
            }
        };
    }

    public static Expression exchangeExceptionExpression(final Class<Exception> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = (Exception)exchange.getException(type);
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                    return ObjectHelper.getException(type, exception);
                }
                return exception;
            }

            public String toString() {
                return "exchangeException[" + type + "]";
            }
        };
    }

    public static Expression exchangeExceptionOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                if (exception == null) {
                    return null;
                }
                return new MethodCallExpression(exception, ognl).evaluate(exchange);
            }

            public String toString() {
                return "exchangeExceptionOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression typeConverterExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getTypeConverter();
            }

            public String toString() {
                return "typeConverter";
            }
        };
    }

    public static Expression registryExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getRegistry();
            }

            public String toString() {
                return "registry";
            }
        };
    }

    public static Expression refExpression(final String ref) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ExpressionBuilder.simpleExpression(ref).evaluate(exchange, String.class);
                return exchange.getContext().getRegistry().lookupByName(text);
            }

            public String toString() {
                return "ref(" + ref + ")";
            }
        };
    }

    public static Expression camelContextExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext();
            }

            public String toString() {
                return "camelContext";
            }
        };
    }

    public static Expression camelContextNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getName();
            }

            public String toString() {
                return "camelContextName";
            }
        };
    }

    public static Expression exchangeExceptionMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                return exception != null ? exception.getMessage() : null;
            }

            public String toString() {
                return "exchangeExceptionMessage";
            }
        };
    }

    public static Expression exchangeExceptionStackTraceExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    IOHelper.close(pw, sw);
                    return sw.toString();
                }
                return null;
            }

            public String toString() {
                return "exchangeExceptionStackTrace";
            }
        };
    }

    @Deprecated
    public static Expression propertyExpression(final String propertyName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ExpressionBuilder.simpleExpression(propertyName).evaluate(exchange, String.class);
                return exchange.getProperty(text);
            }

            public String toString() {
                return "exchangeProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression exchangePropertyExpression(final String propertyName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ExpressionBuilder.simpleExpression(propertyName).evaluate(exchange, String.class);
                return exchange.getProperty(text);
            }

            public String toString() {
                return "exchangeProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression propertyOgnlExpression(String ognl) {
        return new KeyedOgnlExpressionAdapter(ognl, "propertyOgnl(" + ognl + ")", new KeyedOgnlExpressionAdapter.KeyedEntityRetrievalStrategy(){

            @Override
            public Object getKeyedEntity(Exchange exchange, String key) {
                String text = ExpressionBuilder.simpleExpression(key).evaluate(exchange, String.class);
                return exchange.getProperty(text);
            }
        });
    }

    @Deprecated
    public static Expression propertiesExpression() {
        return ExpressionBuilder.exchangeExceptionExpression();
    }

    public static Expression exchangePropertiesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getProperties();
            }

            public String toString() {
                return "exchangeProperties";
            }
        };
    }

    public static Expression camelContextPropertiesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getGlobalOptions();
            }

            public String toString() {
                return "camelContextProperties";
            }
        };
    }

    public static Expression camelContextPropertyExpression(final String propertyName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ExpressionBuilder.simpleExpression(propertyName).evaluate(exchange, String.class);
                return exchange.getContext().getGlobalOption(text);
            }

            public String toString() {
                return "camelContextProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression systemPropertyExpression(String propertyName) {
        return ExpressionBuilder.systemPropertyExpression(propertyName, null);
    }

    public static Expression systemPropertyExpression(final String propertyName, final String defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ExpressionBuilder.simpleExpression(propertyName).evaluate(exchange, String.class);
                String text2 = ExpressionBuilder.simpleExpression(defaultValue).evaluate(exchange, String.class);
                return System.getProperty(text, text2);
            }

            public String toString() {
                return "systemProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression systemEnvironmentExpression(String propertyName) {
        return ExpressionBuilder.systemEnvironmentExpression(propertyName, null);
    }

    public static Expression systemEnvironmentExpression(final String propertyName, final String defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ExpressionBuilder.simpleExpression(propertyName).evaluate(exchange, String.class);
                String answer = System.getenv(text.toUpperCase());
                if (answer == null) {
                    String text2;
                    answer = text2 = ExpressionBuilder.simpleExpression(defaultValue).evaluate(exchange, String.class);
                }
                return answer;
            }

            public String toString() {
                return "systemEnvironment(" + propertyName + ")";
            }
        };
    }

    public static Expression constantExpression(final Object value) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return value;
            }

            public String toString() {
                return "" + value;
            }
        };
    }

    public static Expression languageExpression(final String language, final String expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Language lan = exchange.getContext().resolveLanguage(language);
                if (lan != null) {
                    return lan.createExpression(expression).evaluate(exchange, Object.class);
                }
                throw new NoSuchLanguageException(language);
            }

            @Override
            public boolean matches(Exchange exchange) {
                Language lan = exchange.getContext().resolveLanguage(language);
                if (lan != null) {
                    return lan.createPredicate(expression).matches(exchange);
                }
                throw new NoSuchLanguageException(language);
            }

            public String toString() {
                return "language[" + language + ":" + expression + "]";
            }
        };
    }

    public static Expression typeExpression(final String name) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ExpressionBuilder.simpleExpression(name).evaluate(exchange, String.class);
                Class<?> type = exchange.getContext().getClassResolver().resolveClass(text);
                if (type != null) {
                    return type;
                }
                int pos = text.lastIndexOf(".");
                if (pos > 0) {
                    String before = text.substring(0, pos);
                    String after = text.substring(pos + 1);
                    type = exchange.getContext().getClassResolver().resolveClass(before);
                    if (type != null) {
                        return ObjectHelper.lookupConstantFieldValue(type, after);
                    }
                }
                throw ObjectHelper.wrapCamelExecutionException(exchange, new ClassNotFoundException("Cannot find type " + text));
            }

            public String toString() {
                return "type:" + name;
            }
        };
    }

    public static Expression cacheExpression(final Expression expression) {
        return new ExpressionAdapter(){
            private final AtomicReference<Object> cache = new AtomicReference();

            @Override
            public Object evaluate(Exchange exchange) {
                Object answer = this.cache.get();
                if (answer == null) {
                    answer = expression.evaluate(exchange, Object.class);
                    this.cache.set(answer);
                }
                return answer;
            }

            public String toString() {
                return expression.toString();
            }
        };
    }

    public static Expression bodyExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "body";
            }
        };
    }

    public static Expression bodyExpression(final Function<Object, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody());
            }

            public String toString() {
                return "bodyExpression";
            }
        };
    }

    public static Expression bodyExpression(final BiFunction<Object, Map<String, Object>, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(), exchange.getIn().getHeaders());
            }

            public String toString() {
                return "bodyExpression";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> bodyType, final Function<T, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(bodyType));
            }

            public String toString() {
                return "bodyExpression (" + bodyType + ")";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> bodyType, final BiFunction<T, Map<String, Object>, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(bodyType), exchange.getIn().getHeaders());
            }

            public String toString() {
                return "bodyExpression (" + bodyType + ")";
            }
        };
    }

    public static Expression bodyOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object body = exchange.getIn().getBody();
                if (body == null) {
                    return null;
                }
                return new MethodCallExpression(body, ognl).evaluate(exchange);
            }

            public String toString() {
                return "bodyOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression ognlExpression(final Expression exp, final String ognl) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = exp.evaluate(exchange, Object.class);
                if (value == null) {
                    return null;
                }
                return new MethodCallExpression(value, ognl).evaluate(exchange);
            }

            public String toString() {
                return "ognl(" + exp + ", " + ognl + ")";
            }
        };
    }

    public static Expression camelContextOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                CamelContext context = exchange.getContext();
                if (context == null) {
                    return null;
                }
                return new MethodCallExpression(context, ognl).evaluate(exchange);
            }

            public String toString() {
                return "camelContextOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression exchangeOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return new MethodCallExpression(exchange, ognl).evaluate(exchange);
            }

            public String toString() {
                return "exchangeOgnl(" + ognl + ")";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyExpression(final String name) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text = ExpressionBuilder.simpleExpression(name).evaluate(exchange, String.class);
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + name + "]";
            }
        };
    }

    public static Expression bodyOgnlExpression(final String name, final String ognl) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text = ExpressionBuilder.simpleExpression(name).evaluate(exchange, String.class);
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
                Object body = exchange.getIn().getBody(type);
                if (body != null) {
                    MethodCallExpression call = new MethodCallExpression(exchange, ognl);
                    call.setInstance(body);
                    return call.evaluate(exchange);
                }
                return null;
            }

            public String toString() {
                return "bodyOgnlAs[" + name + "](" + ognl + ")";
            }
        };
    }

    public static Expression mandatoryBodyExpression(final String name) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text = ExpressionBuilder.simpleExpression(name).evaluate(exchange, String.class);
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
                try {
                    return exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
            }

            public String toString() {
                return "mandatoryBodyAs[" + name + "]";
            }
        };
    }

    public static Expression mandatoryBodyOgnlExpression(final String name, final String ognl) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object body;
                Class<?> type;
                String text = ExpressionBuilder.simpleExpression(name).evaluate(exchange, String.class);
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
                try {
                    body = exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
                MethodCallExpression call = new MethodCallExpression(exchange, ognl);
                call.setInstance(body);
                return call.evaluate(exchange);
            }

            public String toString() {
                return "mandatoryBodyAs[" + name + "](" + ognl + ")";
            }
        };
    }

    public static Expression threadNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return Thread.currentThread().getName();
            }

            public String toString() {
                return "threadName";
            }
        };
    }

    public static Expression nullExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return null;
            }

            public String toString() {
                return "null";
            }
        };
    }

    public static <T> Expression mandatoryBodyExpression(Class<T> type) {
        return ExpressionBuilder.mandatoryBodyExpression(type, false);
    }

    public static <T> Expression mandatoryBodyExpression(final Class<T> type, final boolean nullBodyAllowed) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (nullBodyAllowed) {
                    BeanInvocation bi;
                    if (exchange.getIn().getBody() == null) {
                        return null;
                    }
                    if (exchange.getIn().getBody() instanceof BeanInvocation && ((bi = (BeanInvocation)exchange.getIn().getBody()).getArgs() == null || bi.getArgs().length == 0 || bi.getArgs()[0] == null)) {
                        return null;
                    }
                }
                try {
                    return exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
            }

            public String toString() {
                return "mandatoryBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyTypeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody().getClass();
            }

            public String toString() {
                return "bodyType";
            }
        };
    }

    public static Expression outBodyExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (exchange.hasOut()) {
                    return exchange.getOut().getBody();
                }
                return null;
            }

            public String toString() {
                return "outBody";
            }
        };
    }

    public static <T> Expression outBodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (exchange.hasOut()) {
                    return exchange.getOut().getBody(type);
                }
                return null;
            }

            public String toString() {
                return "outBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression faultBodyExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
                return msg.isFault() ? msg.getBody() : null;
            }

            public String toString() {
                return "faultBody";
            }
        };
    }

    public static <T> Expression faultBodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
                return msg.isFault() ? msg.getBody(type) : null;
            }

            public String toString() {
                return "faultBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression exchangeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange;
            }

            public String toString() {
                return "exchange";
            }
        };
    }

    public static Expression exchangeExpression(final Function<Exchange, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange);
            }

            public String toString() {
                return "exchangeExpression";
            }
        };
    }

    public static Expression messageExpression() {
        return ExpressionBuilder.inMessageExpression();
    }

    public static Expression messageExpression(Function<Message, Object> function) {
        return ExpressionBuilder.inMessageExpression(function);
    }

    public static Expression inMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn();
            }

            public String toString() {
                return "inMessage";
            }
        };
    }

    public static Expression inMessageExpression(final Function<Message, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn());
            }

            public String toString() {
                return "inMessageExpression";
            }
        };
    }

    public static Expression outMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getOut();
            }

            public String toString() {
                return "outMessage";
            }
        };
    }

    public static Expression outMessageExpression(final Function<Message, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getOut());
            }

            public String toString() {
                return "outMessageExpression";
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Class<?> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (type != null) {
                    return expression.evaluate(exchange, type);
                }
                return expression;
            }

            public String toString() {
                return "" + expression;
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Expression type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object result = type.evaluate(exchange, Object.class);
                if (result != null) {
                    return expression.evaluate(exchange, result.getClass());
                }
                return expression;
            }

            public String toString() {
                return "" + expression;
            }
        };
    }

    public static Expression tokenizeExpression(final Expression expression, final String token) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ExpressionBuilder.simpleExpression(token).evaluate(exchange, String.class);
                Object value = expression.evaluate(exchange, Object.class);
                Scanner scanner = ObjectHelper.getScanner(exchange, value, text);
                return scanner;
            }

            public String toString() {
                return "tokenize(" + expression + ", " + token + ")";
            }
        };
    }

    public static Expression skipFirstExpression(final Expression expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Iterator it = exchange.getContext().getTypeConverter().tryConvertTo(Iterator.class, exchange, value);
                if (it != null) {
                    it.next();
                    return it;
                }
                return value;
            }

            public String toString() {
                return "skipFirst(" + expression + ")";
            }
        };
    }

    public static Expression tokenizePairExpression(String startToken, String endToken, boolean includeTokens) {
        return new TokenPairExpressionIterator(startToken, endToken, includeTokens);
    }

    public static Expression tokenizeXMLExpression(String tagName, String inheritNamespaceTagName) {
        StringHelper.notEmpty(tagName, "tagName");
        return new TokenXMLExpressionIterator(tagName, inheritNamespaceTagName);
    }

    public static Expression tokenizeXMLAwareExpression(String path, char mode) {
        StringHelper.notEmpty(path, "path");
        return new XMLTokenExpressionIterator(path, mode);
    }

    public static Expression tokenizeXMLAwareExpression(String path, char mode, int group) {
        StringHelper.notEmpty(path, "path");
        return new XMLTokenExpressionIterator(path, mode, group);
    }

    public static Expression regexTokenizeExpression(final Expression expression, final String regexTokenizer) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Scanner scanner = ObjectHelper.getScanner(exchange, value, regexTokenizer);
                return scanner;
            }

            public String toString() {
                return "regexTokenize(" + expression + ", " + regexTokenizer + ")";
            }
        };
    }

    public static Expression groupXmlIteratorExpression(final Expression expression, final String group) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull(it, "expression: " + expression + " evaluated on " + exchange + " must return an java.util.Iterator");
                Integer parts = exchange.getContext().resolveLanguage("simple").createExpression(group).evaluate(exchange, Integer.class);
                if (parts == null) {
                    throw new RuntimeExchangeException("Group evaluated as null, must be evaluated as a positive Integer value from expression: " + group, exchange);
                }
                if (parts <= 0) {
                    throw new RuntimeExchangeException("Group must be a positive number, was: " + parts, exchange);
                }
                return new GroupTokenIterator(exchange, it, null, parts, false);
            }

            public String toString() {
                return "group " + expression + " " + group + " times";
            }
        };
    }

    public static Expression groupIteratorExpression(final Expression expression, final String token, final String group, final boolean skipFirst) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull(it, "expression: " + expression + " evaluated on " + exchange + " must return an java.util.Iterator");
                Integer parts = exchange.getContext().resolveLanguage("simple").createExpression(group).evaluate(exchange, Integer.class);
                if (parts == null) {
                    throw new RuntimeExchangeException("Group evaluated as null, must be evaluated as a positive Integer value from expression: " + group, exchange);
                }
                if (parts <= 0) {
                    throw new RuntimeExchangeException("Group must be a positive number, was: " + parts, exchange);
                }
                if (token != null) {
                    return new GroupTokenIterator(exchange, it, token, parts, skipFirst);
                }
                return new GroupIterator(exchange, it, parts, skipFirst);
            }

            public String toString() {
                return "group " + expression + " " + group + " times";
            }
        };
    }

    public static Expression skipIteratorExpression(final Expression expression, final int skip) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull(it, "expression: " + expression + " evaluated on " + exchange + " must return an java.util.Iterator");
                return new SkipIterator(exchange, it, skip);
            }

            public String toString() {
                return "skip " + expression + " " + skip + " times";
            }
        };
    }

    public static Expression sortExpression(final Expression expression, final Comparator comparator) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                List list = expression.evaluate(exchange, List.class);
                list.sort(comparator);
                return list;
            }

            public String toString() {
                return "sort(" + expression + " by: " + comparator + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final String replacement) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                if (text == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final Expression replacementExpression) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                String replacement = replacementExpression.evaluate(exchange, String.class);
                if (text == null || replacement == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression append(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return left.evaluate(exchange, String.class) + right.evaluate(exchange, String.class);
            }

            public String toString() {
                return "append(" + left + ", " + right + ")";
            }
        };
    }

    public static Expression prepend(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return right.evaluate(exchange, String.class) + left.evaluate(exchange, String.class);
            }

            public String toString() {
                return "prepend(" + left + ", " + right + ")";
            }
        };
    }

    public static Expression concatExpression(Collection<Expression> expressions) {
        return ExpressionBuilder.concatExpression(expressions, null);
    }

    public static Expression concatExpression(final Collection<Expression> expressions, final String desription) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                StringBuilder buffer = new StringBuilder();
                for (Expression expression : expressions) {
                    String text = expression.evaluate(exchange, String.class);
                    if (text == null) continue;
                    buffer.append(text);
                }
                return buffer.toString();
            }

            public String toString() {
                if (desription != null) {
                    return desription;
                }
                return "concat" + expressions;
            }
        };
    }

    public static Expression messageIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getMessageId();
            }

            public String toString() {
                return "messageId";
            }
        };
    }

    public static Expression exchangeIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getExchangeId();
            }

            public String toString() {
                return "exchangeId";
            }
        };
    }

    public static Expression routeIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                RouteContext rc;
                String answer = null;
                UnitOfWork uow = exchange.getUnitOfWork();
                RouteContext routeContext = rc = uow != null ? uow.getRouteContext() : null;
                if (rc != null) {
                    answer = rc.getRoute().getId();
                }
                if (answer == null) {
                    answer = exchange.getFromRouteId();
                }
                return answer;
            }

            public String toString() {
                return "routeId";
            }
        };
    }

    public static Expression dateExpression(String command) {
        return ExpressionBuilder.dateExpression(command, null, null);
    }

    public static Expression dateExpression(String command, String pattern) {
        return ExpressionBuilder.dateExpression(command, null, pattern);
    }

    public static Expression dateExpression(final String commandWithOffsets, final String timezone, final String pattern) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String key;
                Date date;
                String command = commandWithOffsets.split("[+-]", 2)[0].trim();
                ArrayList<Long> offsets = new ArrayList<Long>();
                Matcher offsetMatcher = OFFSET_PATTERN.matcher(commandWithOffsets);
                while (offsetMatcher.find()) {
                    try {
                        long value = exchange.getContext().getTypeConverter().mandatoryConvertTo(Long.TYPE, exchange, offsetMatcher.group(2).trim());
                        offsets.add(offsetMatcher.group(1).equals("+") ? value : -value);
                    }
                    catch (NoTypeConversionAvailableException e) {
                        throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                    }
                }
                if ("now".equals(command)) {
                    date = new Date();
                } else if (command.startsWith("header.") || command.startsWith("in.header.")) {
                    key = command.substring(command.lastIndexOf(46) + 1);
                    date = exchange.getIn().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find java.util.Date object at command: " + command);
                    }
                } else if (command.startsWith("out.header.")) {
                    key = command.substring(command.lastIndexOf(46) + 1);
                    date = exchange.getOut().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find java.util.Date object at command: " + command);
                    }
                } else if (command.startsWith("property.") || command.startsWith("exchangeProperty.")) {
                    key = command.substring(command.lastIndexOf(46) + 1);
                    date = exchange.getProperty(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find java.util.Date object at command: " + command);
                    }
                } else if ("file".equals(command)) {
                    Long num = exchange.getIn().getHeader("CamelFileLastModified", Long.class);
                    if (num != null && num > 0L) {
                        date = new Date(num);
                    } else {
                        date = exchange.getIn().getHeader("CamelFileLastModified", Date.class);
                        if (date == null) {
                            throw new IllegalArgumentException("Cannot find CamelFileLastModified header at command: " + command);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Command not supported for dateExpression: " + command);
                }
                long dateAsLong = date.getTime();
                Iterator iterator = offsets.iterator();
                while (iterator.hasNext()) {
                    long offset = (Long)iterator.next();
                    dateAsLong += offset;
                }
                date = new Date(dateAsLong);
                if (pattern != null && !pattern.isEmpty()) {
                    SimpleDateFormat df = new SimpleDateFormat(pattern);
                    if (timezone != null && !timezone.isEmpty()) {
                        df.setTimeZone(TimeZone.getTimeZone(timezone));
                    }
                    return df.format(date);
                }
                return date;
            }

            public String toString() {
                return "date(" + commandWithOffsets + ":" + pattern + ":" + timezone + ")";
            }
        };
    }

    public static Expression simpleExpression(final String expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (SimpleLanguage.hasSimpleFunction(expression)) {
                    Language language = exchange.getContext().resolveLanguage("simple");
                    return language.createExpression(expression).evaluate(exchange, Object.class);
                }
                return expression;
            }

            public String toString() {
                return "simple(" + expression + ")";
            }
        };
    }

    public static Expression beanExpression(final String expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Language language = exchange.getContext().resolveLanguage("bean");
                return language.createExpression(expression).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "bean(" + expression + ")";
            }
        };
    }

    @Deprecated
    public static Expression beanExpression(Class<?> beanType, String methodName) {
        return BeanLanguage.bean(beanType, methodName);
    }

    @Deprecated
    public static Expression beanExpression(Object bean, String methodName) {
        return BeanLanguage.bean(bean, methodName);
    }

    @Deprecated
    public static Expression beanExpression(String beanRef, String methodName) {
        String expression = methodName != null ? beanRef + "." + methodName : beanRef;
        return ExpressionBuilder.beanExpression(expression);
    }

    @Deprecated
    public static Expression toExpression(final String uri) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ExpressionBuilder.simpleExpression(uri).evaluate(exchange, String.class);
                Endpoint endpoint = exchange.getContext().getEndpoint(text);
                if (endpoint == null) {
                    throw new NoSuchEndpointException(text);
                }
                try {
                    Producer producer = endpoint.createProducer();
                    producer.start();
                    producer.process(exchange);
                    producer.stop();
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
                if (ExchangeHelper.isOutCapable(exchange)) {
                    return exchange.getOut().getBody();
                }
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "to(" + uri + ")";
            }
        };
    }

    public static Expression fileNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileName", String.class);
            }

            public String toString() {
                return "file:name";
            }
        };
    }

    public static Expression fileOnlyNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String answer = exchange.getIn().getHeader("CamelFileNameOnly", String.class);
                if (answer == null) {
                    answer = exchange.getIn().getHeader("CamelFileName", String.class);
                    answer = FileUtil.stripPath(answer);
                }
                return answer;
            }

            public String toString() {
                return "file:onlyname";
            }
        };
    }

    public static Expression fileNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.stripExt(name);
            }

            public String toString() {
                return "file:name.noext";
            }
        };
    }

    public static Expression fileNameNoExtensionSingleExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.stripExt(name, true);
            }

            public String toString() {
                return "file:name.noext.single";
            }
        };
    }

    public static Expression fileOnlyNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = ExpressionBuilder.fileOnlyNameExpression().evaluate(exchange, String.class);
                return FileUtil.stripExt(name);
            }

            public String toString() {
                return "file:onlyname.noext";
            }
        };
    }

    public static Expression fileOnlyNameNoExtensionSingleExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = ExpressionBuilder.fileOnlyNameExpression().evaluate(exchange, String.class);
                return FileUtil.stripExt(name, true);
            }

            public String toString() {
                return "file:onlyname.noext.single";
            }
        };
    }

    public static Expression fileExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.onlyExt(name);
            }

            public String toString() {
                return "file:ext";
            }
        };
    }

    public static Expression fileExtensionSingleExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.onlyExt(name, true);
            }

            public String toString() {
                return "file:ext.single";
            }
        };
    }

    public static Expression fileParentExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileParent", String.class);
            }

            public String toString() {
                return "file:parent";
            }
        };
    }

    public static Expression filePathExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFilePath", String.class);
            }

            public String toString() {
                return "file:path";
            }
        };
    }

    public static Expression fileAbsolutePathExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolutePath", String.class);
            }

            public String toString() {
                return "file:absolute.path";
            }
        };
    }

    public static Expression fileAbsoluteExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolute", Boolean.class);
            }

            public String toString() {
                return "file:absolute";
            }
        };
    }

    public static Expression fileSizeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLength", Long.class);
            }

            public String toString() {
                return "file:length";
            }
        };
    }

    public static Expression fileLastModifiedExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLastModified", Long.class);
            }

            public String toString() {
                return "file:modified";
            }
        };
    }

    public static Expression parseSimpleOrFallbackToConstantExpression(String str, CamelContext camelContext) {
        if (StringHelper.hasStartToken(str, "simple")) {
            return camelContext.resolveLanguage("simple").createExpression(str);
        }
        return ExpressionBuilder.constantExpression(str);
    }

    public static Expression propertiesComponentExpression(final String key, final String locations, final String defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ExpressionBuilder.simpleExpression(key).evaluate(exchange, String.class);
                String text2 = ExpressionBuilder.simpleExpression(locations).evaluate(exchange, String.class);
                try {
                    if (text2 != null) {
                        Component component = exchange.getContext().getComponent("properties");
                        PropertiesComponent pc = exchange.getContext().getTypeConverter().mandatoryConvertTo(PropertiesComponent.class, component);
                        String[] paths = text2.split(",");
                        return pc.parseUri(pc.getPrefixToken() + text + pc.getSuffixToken(), paths);
                    }
                    Component component = exchange.getContext().hasComponent("properties");
                    if (component == null) {
                        throw new IllegalArgumentException("PropertiesComponent with name properties must be defined in CamelContext to support property placeholders in expressions");
                    }
                    PropertiesComponent pc = exchange.getContext().getTypeConverter().mandatoryConvertTo(PropertiesComponent.class, component);
                    return pc.parseUri(pc.getPrefixToken() + text + pc.getSuffixToken());
                }
                catch (Exception e) {
                    if (defaultValue != null) {
                        return defaultValue;
                    }
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }

            public String toString() {
                return "properties(" + key + ")";
            }
        };
    }

    public static Expression randomExpression(int max) {
        return ExpressionBuilder.randomExpression(0, max);
    }

    public static Expression randomExpression(final int min, final int max) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Random random = new Random();
                int randomNum = random.nextInt(max - min) + min;
                return randomNum;
            }

            public String toString() {
                return "random(" + min + "," + max + ")";
            }
        };
    }

    public static Expression randomExpression(final String min, final String max) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                int num1 = ExpressionBuilder.simpleExpression(min).evaluate(exchange, Integer.class);
                int num2 = ExpressionBuilder.simpleExpression(max).evaluate(exchange, Integer.class);
                Random random = new Random();
                int randomNum = random.nextInt(num2 - num1) + num1;
                return randomNum;
            }

            public String toString() {
                return "random(" + min + "," + max + ")";
            }
        };
    }

    public static Expression skipExpression(final String expression, final int number) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Expression exp = exchange.getContext().resolveLanguage("simple").createExpression(expression);
                return ExpressionBuilder.skipIteratorExpression(exp, number).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "skip(" + expression + "," + number + ")";
            }
        };
    }

    public static Expression collateExpression(final String expression, final int group) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Expression exp = exchange.getContext().resolveLanguage("simple").createExpression(expression);
                return ExpressionBuilder.groupIteratorExpression(exp, null, "" + group, false).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "collate(" + expression + "," + group + ")";
            }
        };
    }

    public static Expression messageHistoryExpression(final boolean detailed) {
        return new ExpressionAdapter(){
            private ExchangeFormatter formatter;

            @Override
            public Object evaluate(Exchange exchange) {
                ExchangeFormatter ef = null;
                if (detailed) {
                    ef = this.getOrCreateExchangeFormatter(exchange.getContext());
                }
                return MessageHelper.dumpMessageHistoryStacktrace(exchange, ef, false);
            }

            private ExchangeFormatter getOrCreateExchangeFormatter(CamelContext camelContext) {
                if (this.formatter == null) {
                    Set<ExchangeFormatter> formatters = camelContext.getRegistry().findByType(ExchangeFormatter.class);
                    if (formatters != null && formatters.size() == 1) {
                        this.formatter = formatters.iterator().next();
                    } else {
                        DefaultExchangeFormatter def = new DefaultExchangeFormatter();
                        def.setShowExchangeId(true);
                        def.setMultiline(true);
                        def.setShowHeaders(true);
                        def.setStyle(DefaultExchangeFormatter.OutputStyle.Fixed);
                        try {
                            Integer maxChars = CamelContextHelper.parseInteger(camelContext, camelContext.getGlobalOption("CamelLogDebugBodyMaxChars"));
                            if (maxChars != null) {
                                def.setMaxChars(maxChars);
                            }
                        }
                        catch (Exception e) {
                            throw ObjectHelper.wrapRuntimeCamelException(e);
                        }
                        this.formatter = def;
                    }
                }
                return this.formatter;
            }

            public String toString() {
                return "messageHistory(" + detailed + ")";
            }
        };
    }

    private static class KeyedOgnlExpressionAdapter
    extends ExpressionAdapter {
        private final String ognl;
        private final String toStringValue;
        private final KeyedEntityRetrievalStrategy keyedEntityRetrievalStrategy;

        KeyedOgnlExpressionAdapter(String ognl, String toStringValue, KeyedEntityRetrievalStrategy keyedEntityRetrievalStrategy) {
            this.ognl = ognl;
            this.toStringValue = toStringValue;
            this.keyedEntityRetrievalStrategy = keyedEntityRetrievalStrategy;
        }

        @Override
        public Object evaluate(Exchange exchange) {
            Object property = this.keyedEntityRetrievalStrategy.getKeyedEntity(exchange, this.ognl);
            if (property != null) {
                return property;
            }
            List<String> methods = OgnlHelper.splitOgnl(this.ognl);
            String key = methods.get(0);
            String keySuffix = "";
            if (key.startsWith("[") && key.endsWith("]")) {
                key = StringHelper.removeLeadingAndEndingQuotes(key.substring(1, key.length() - 1));
                keySuffix = StringHelper.after(methods.get(0), key);
            }
            if ((property = this.keyedEntityRetrievalStrategy.getKeyedEntity(exchange, key = OgnlHelper.removeOperators(key))) == null) {
                return null;
            }
            String remainder = StringHelper.after(this.ognl, key + keySuffix);
            return new MethodCallExpression(property, remainder).evaluate(exchange);
        }

        public String toString() {
            return this.toStringValue;
        }

        public static interface KeyedEntityRetrievalStrategy {
            public Object getKeyedEntity(Exchange var1, String var2);
        }
    }
}

